﻿#!/usr/bin/python

import ftplib

def ftp_upload(filename, ftpFileName, serverAddr, port, username, password, dirName=None):
    '''upload a file to FTP Server
    filename: the file name in local side
    ftpFileName: the file name in FTP side
    serverAddr, port: FTP Server address and port
    username, password: username and password of FTP (ex: anonymous for no password guest)
    dirName: the Folder to upload
    '''
    resultData = ''
    try:
        resultData += 'connect FTP Server\r\n'
        ftp = ftplib.FTP()
        ftp.connect(serverAddr, port)
        resultData += 'login\r\n'
        ftp.login(username, password)
        if(dirName!=None):
            try:
                resultData += ('CD dir "%s"\r\n' %(dirName))
                ftp.cwd(dirName)
            except:
                resultData += ('fails to CD dir "%s"\r\n' %(dirName))
                #fails to chage dir --> maybe dir don't exit --> create it
                resultData += ('create new dir "%s"\r\n' %(dirName))
                ftp.mkd(dirName)
                resultData += ('CD dir "%s"\r\n' %(dirName))
                ftp.cwd(dirName)

        resultData += 'open and upload the file\r\n'
        f = open(filename, 'rb') #先開要上傳的檔案
        ftp.storbinary('STOR '+ftpFileName, f) #把data stream寫到ftp
        f.close()
        ftp.quit()
    except Exception, e:
        return (resultData + "Exception: " + str(e))
    return None

'''
res = ftp_upload('GRP-520_20140127_235946.csv', 'localhost', 2121, 'test', 'test', 'GRP-520_log/2014/')
if(res == None):
    print 'upload success'
else:
    print res
'''
