﻿#!/usr/bin/python

#send mail via gmail-server, TLS (Transport Layer Security) mode
import time

import smtplib
import email.utils

from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from email.mime.image import MIMEImage

from email.mime.base import MIMEBase
from email import encoders

def sendEmail(fromAddr, toAddr, subject, text, username=None, password=None,
        servername="smtp.gmail.com", serverPort=None, fileName=None, mailFileName=None):
    """ fromAddr:   string, mail sent from this address
        toAddr:     mail address, ex: 'aaa@gmail.com,bbb@gmail.com'
        subject:    string, mail title
        text:       string, contents
        username:   username of mail
        password:   password of mail
        servername: your server address
        serverPort: the port of the mail server
        fileName:   file name attached in local side
        mailFileName: attachment file name in the mail
    """
    # msg of MIME Multipart to contain all MIME object
    msg = MIMEMultipart()
    msg['From'] = fromAddr
    msg['To'] = toAddr
    msg['Subject'] = subject

    # contentx for MIME
    Contents = MIMEText(text)
    msg.attach(Contents)

    # attachment MIME
    if (fileName!=None):
        try:
            fp = open(fileName, 'rb')
            att = MIMEBase('application', 'octet-stream')
            att.set_payload(fp.read())
            fp.close()
            # Encode the payload using Base64
            encoders.encode_base64(att)
            att.add_header('content-disposition','attachment',filename=mailFileName)
            msg.attach(att)
        except Exception, e:
            return "EMail: Open file Error. " + str(e)

    # connect Mail Server and Send mail
    if(serverPort==None):
        smtp = smtplib.SMTP(servername)
    else:
        smtp = smtplib.SMTP(servername, serverPort)
    try:
        #smtp.set_debuglevel(True)
        #  identify  ourselves,  prompting  server  for  supported  features
        smtp.ehlo()
        #  If  we  can  encrypt  this  session,  do  it
        if smtp.has_extn('STARTTLS'):
            #print "====\n smtp.has_extn('STARTTLS')==True \n===="
            smtp.starttls()
            smtp.ehlo()  #  reidentify  ourselves  over  TLS  connection

        smtp.login(username,  password)
        smtp.sendmail(fromAddr, toAddr.split(","), msg.as_string())
    except Exception, e:
        return "EMail: Send Error. " + str(e)
    finally:
        smtp.quit()

    return (None)

'''
fromMail = 'malo.grp@icpdas.com'
toMails = 'yguma.yang@gmail.com' #'maloyang@gmail.com,yguma.yang@gmail.com,kane_tsai@icpdas.com'
title = "Malo Mail"
text = "hi~ I'm malo"
mailServer = 'smtp.gmail.com'
userName = 'malo.grp'
password = 'icpdasicpdas'
fileName = 'rtu.ini'
res = sendEmail(fromMail, toMails, title, text, userName, password, mailServer, 587, fileName)
if(res == None):
    print '->email report success '
else:
    print '->Email Fails '
'''
'''
fromMail = 'malo_yang@icpdas.com'
toMails = 'yguma.yang@gmail.com' #'maloyang@gmail.com,yguma.yang@gmail.com,kane_tsai@icpdas.com'
title = "Malo Mail"
text = "hi~ I'm malo"
mailServer = 'mail.icpdas.com'
mailPort = 25
userName = 'malo_yang'
password = 'ml410'
fileName = 'rtu.txt'
res = sendEmail(fromMail, toMails, title, text, userName, password, mailServer, mailPort, fileName, fileName)
if(res == None):
    print '->email report success '
else:
    print '->Email Fails '
'''
