#!/usr/bin/php
<?php

$serverIP="tock.stdtime.gov.tw";
$retryInterval=60*60;//1 hour
$timezone="+8";
$GSM_shutdownDelay = 10;
$logFile = '/icpdas/ntpc/ntpc.log';

// (1) read configure file
if($argc==1)
{
	$data=file_get_contents("/icpdas/ntpc/ntpc.ini");
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);
		if($line[0]=='#') continue;

		list($name , $value)=split('=' , $line);
		if($name == "serverIP"){
			$serverIP = $value;
		}else if($name == "interval")
		{
			$retryInterval = (int)$value;
		}else if($name == "timezone")
		{
			$timezone = $value;
		}
	}
}
//(2) display some information
if($argc>=2)
{
	if($argv[1]=="--help")
	{
		echo "Usage: ntpcDeamon.php\n";
		echo "  ntpcDeamon will request time information from time server every 1 hour\n";
		echo "  (version = v1.0.0 2014/05/22)\n";
	}else if($argv[1]=="--ver")
	{
        echo "version = v1.0.0 2014/05/22\n";
	}

	return;
}

if(true)
{
    echo "==== ntpcDeamon start ====\n";
	echo "  serverIP = ".$serverIP."\n";
	echo "  retryInterval = ".$retryInterval."\n";
	logTime("==== ntpcDeamon start ====", $logFile);
	logTime("serverIP=".$serverIP.", "
            ."retryInterval=".$retryInterval, $logFile);
	//return;
}

$retry_n = 0;
while(1)
{
    //- ntp update
    $cmd = "ntpdate " .$serverIP;//"ntpdate tock.stdtime.gov.tw"
    $result = shell_exec($cmd);
    if(strstr($result, "adjust time server"))
    {
        echo "NTP update successfully\n";
        logTime("NTP update successfully: ".$result, $logFile);
    }else
    {
        echo "NTP update fails, please check the address\n";
        logTime("NTP update fails: ".$result, $logFile);
    }

    //- write into RTC
    $cmd = "hwclock -uw";
    $result = shell_exec($cmd);

	sleep($retryInterval);
}

function logTime($message="", $logFile)
{
    $MAX_LINE = 100;
    $info = file_get_contents($logFile);
    $info_array = explode("\n", $info);
    $lineNum = sizeof($info_array);
    //1000 log (約10kB)
    if($lineNum<$MAX_LINE)
    {
        $info_array[] = ("[".date('Y/m/d H:i:s')."] " .$message );
    }else
    {
        $info_array = array_slice($info_array, -1*$MAX_LINE, $MAX_LINE);
        $info_array[] = ("[".date('Y/m/d H:i:s')."] " .$message );
    }
    $data=implode("\n",$info_array);
    file_put_contents($logFile,$data);
}
?>

