
<html>
<head>
<meta content="text/html; charset=UTF-8" http-equiv="content-type">
<title></title>
</head>

<body>
<?php
//====================================
//== get and setting GPRS parameter ==
//====================================

require_once("./class.php");

//== set pppd configure
function setVpncCfg($serverIp, $uname, $upwd)
{
	//- set username, vpn server ip in "/etc/ppp/peers/vpn-pptp"
	$data="pty \"pptp " . $serverIp ." --nolaunchpppd\"\n"
		."name " . $uname ."\n"
		."remotename PPTP\n"
		."require-mppe-128\n"
		."file /etc/ppp/options.pptp\n"
		.'ipparam $IPPARAM';
	file_put_contents("/etc/ppp/peers/vpn-pptp", $data);


	//set user name and password
	//Using CHAP(Challenge-Handshake Authentication Protocol)
	$data=file_get_contents("/etc/ppp/chap-secrets");
	$array_data=explode("\n",$data);
	$n = 0;
	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);
		if($line[0]=='#') continue;

		if($n++>=1)
		{
			$line="\"" .$uname ."\"\t" ."*" ."\t\"" .$upwd ."\"";
			$array_data[$index] = $line;
			break;
		}
	}
	$data=implode("\n", $array_data);
	file_put_contents("/etc/ppp/chap-secrets", $data);
}

function getVpncCfg(&$serverIp, &$uname, &$upwd)
{
	//- get ServerIp
	$data=file_get_contents("/etc/ppp/peers/vpn-pptp");
	$array_data=explode("\n",$data);
	$line = substr($array_data[0], 10);
	$items = explode(" ", $line);
	$serverIp = $items[0];

	//Using CHAP(Challenge-Handshake Authentication Protocol)
	$data=file_get_contents("/etc/ppp/chap-secrets");
	$array_data=explode("\n",$data);
	$n = 0;
	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);
		if($line[0]=='#') continue;

		if($n++>=1)
		{
			$items = explode("\t",$line);
			$uname = trim($items[0], '"');
			$upwd = trim($items[2], '"');
			break;
		}
	}
}

//- get process name
$proc_name = CommonData::$VPNC_EXE;
$full_file_name = CommonData::$VPNC_DIR ."/" .$proc_name;

if($_POST["submit"]=="Modify")	//press "Modify" button
{
	$user = trim($_POST["vpnc_user"]);
	$password = trim($_POST["vpnc_password"]);
	$serverIp = trim($_POST["vpnc_serverIp"]);
	$enable = $_POST["enable"];
	if($enable=="enable")
		$enable="enable";
	else
		$enable="disable";

	//-- set configure file
	setVpncCfg($serverIp, $user, $password);
	echo "<div align=\"center\"><font color=\"#cc0000\">setting success!!</font><br>\n";

	//-- set firmware as auto-executable and add into User process file
	//- php call php-script時，需要把「輸入/輸出」重導到別的地方，不可用std io，否則不會執行成功
	addUserProc("VPN Client Monitor", $full_file_name ." > /dev/null", "/usr/bin/killall -9 " .$proc_name, $full_file_name, $enable);
	getUserProcCgf($proc_list);
	setAutoRunFW($proc_list);

	//-- Start/Stop firmware
	$n = count($proc_list);
	for($i=0; $i<$n; $i++)
	{
		if($proc_list[$i]["exec"] == $full_file_name)
		{
			//enable--> restart FW
			if($enable=="enable")
			{
				shell_exec($proc_list[$i]["stop"]);
				pclose(popen($proc_list[$i]["start"] ." &", "r"));//put into backgroud, or php will be block
				echo "<div align=\"center\"><font color=\"#cc0000\">Execute ".$proc_list[$i]["name"]." successfully</font><br>\n";
				break;
			}else
			{
				shell_exec($proc_list[$i]["stop"]);
				echo "<div align=\"center\"><font color=\"#cc0000\">Stop ".$proc_list[$i]["name"]." successfully</font><br>\n";
				break;
			}
		}
	}

}

//READ INFORMATION
//-- vpn client config : user, password
getVpncCfg($serverIp, $user, $password);

//--check if function is enable
getUserProcCgf($proc_list);
$n = count($proc_list);
for($i=0; $i<$n; $i++)
{
	if($proc_list[$i]["exec"] == $full_file_name)
	{
		$enable = $proc_list[$i]["autorun"];
		$alive = $proc_list[$i]["running"];
		break;
	}
}

//- get version
$version = shell_exec($full_file_name ." --ver");
$array_data = explode("=", $version);
$version = trim($array_data[1]);

?>


	<br>
	<form method="post" name="ethernet"><br><!-- 加入 action="aa.html" 可以指定給誰處理 -->
		<table align="center" border="1" cellpadding="2" cellspacing="2" width="600">
		<tbody>

		<tr align="center">
			<td colspan="2" bgcolor="#ffcc99">VPN Client Configure (support PPTP VPN)<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Server Address</td>
			<td ><input size="20" name="vpnc_serverIp" value="<?php echo $serverIp;?>" >
			ex.: us.pptpvpn.org
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">User Name</td>
			<td ><input size="20" name="vpnc_user" value="<?php echo $user;?>" >
			ex.: pptpvpn.org
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Password</td>
			<td ><input size="20" name="vpnc_password" value="<?php echo $password;?>" >
			ex.: 7911
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Enable</td>
			<td ><input size="20" name="enable" type="checkbox" value="enable"<?php if($enable=="enable") echo "checked";?> >Enable <br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Alive</td>
			<?php
				if($alive == "true")
				{
					echo '<td bgcolor="#33ff33">True</td>'."\n";
				}else
				{
					echo '<td bgcolor="#cccccc">False</td>'."\n";
				}
			?>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Firmware Version</td>
			<td ><?php echo $version;?></td>
		</tr>

		<tr align="center">
			<td colspan="2"><input name="submit" value="Modify" type="submit"><br>
			</td>
		</tr>

		</tbody>
		</table>

		<br>
		<br>
	</form>
	<br>
	<br>
</body>
</html>

