
<html>
<head>
<meta content="text/html; charset=UTF-8" http-equiv="content-type">
<title></title>
</head>

<body>
<?php
//====================================
//== get and setting DDNS configure ==
//====================================

require_once("./class.php");

//== get DDNS configure
function getddnsCfg(&$server, &$domain, &$uname, &$upwd, &$period, &$enable)
{
	$data=file_get_contents(CommonData::$DDNS_SETTING_FILE);
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);
		if($line[0]=='#') continue;

		if(($pos=strpos($line, "dyndns_system")) !== false)
		{
			$server = trim(substr($line, $pos+13));

		}else if(($pos=strpos($line, "alias")) !== false)
		{
			$domain = trim(substr($line, $pos+5));

		}else if(($pos=strpos($line, "username")) !== false)
		{
			$uname = trim(substr($line, $pos+8));

		}else if(($pos=strpos($line, "password")) !== false)
		{
			$upwd = trim(substr($line, $pos+8));

		}else if(($pos=strpos($line, "update_period_sec")) !== false)
		{
			$period = trim(substr($line, $pos+17));
		}
	}

	//check Start sh in "/etc/init.d/"
	if(file_exists("/etc/init.d/S" .CommonData::$DDNS_RUN_SCRIPT))
		$enable="enable";
	else
		$enable="disable";
}

//== set DDNS configure
function setddnsCfg($server, $domain, $uname, $upwd, $period, $enable)
{
	$data=file_get_contents(CommonData::$DDNS_SETTING_FILE);
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);
		if($line[0]=='#') continue;

		if(strpos($line, "dyndns_system") !== false)
		{
			$line = "dyndns_system " .$server;
			$array_data[$index] = $line;

		}else if(($pos=strpos($line, "alias")) !== false)
		{
			$line = "alias " .$domain;
			$array_data[$index] = $line;

		}else if(($pos=strpos($line, "username")) !== false)
		{
			$line = "username " .$uname;
			$array_data[$index] = $line;

		}else if(($pos=strpos($line, "password")) !== false)
		{
			$line = "password " .$upwd;
			$array_data[$index] = $line;

		}else if(($pos=strpos($line, "update_period_sec")) !== false)
		{
			$line = "update_period_sec " .$period;
			$array_data[$index] = $line;
		}
	}

	$data=implode("\n", $array_data);
	file_put_contents(CommonData::$DDNS_SETTING_FILE, $data);

	//set Start sh in "/etc/init.d/"
	$ddns_content =
        "\n"
        ."case \"$1\" in\n"
        ."  start)\n"
        ."      echo \"start ddns client\"\n"
        ."      /icpdas/bin/ddns_inadyn.exe\n"
        ."      ;;\n"
        ."  stop)\n"
        ."      echo \"Stop ddns client\"\n"
        ."      killall ddns_inadyn.exe\n"
        ."      ;;\n"
        ."  restart|reload)\n"
        ."      \"$0\" stop\n"
        ."      \"$0\" start\n"
        ."      ;;\n"
        ."  *)\n"
        ."  echo $\"Usage: $0 {start|stop|restart}\"\n"
        ."  exit 1\n"
        ."esac\n"
        ."exit $?\n";
    /* 原內容為：
    ########################
    # ddns client deamon
    ########################

    case "$1" in
      start)
            echo "start ddns client"
            /icpdas/bin/ddns_inadyn.exe
            ;;
      stop)
            echo -n "Stop ddns client"
            killall ddns_inadyn.exe
            ;;
      restart|reload)
            "$0" stop
            "$0" start
            ;;

      *)
            echo $"Usage: $0 {start|stop|restart}"
            exit 1
    esac
    exit $?
    */
    if(file_exists("/etc/init.d/S" .CommonData::$DDNS_RUN_SCRIPT))
        unlink("/etc/init.d/S" .CommonData::$DDNS_RUN_SCRIPT);
    if(file_exists("/etc/init.d/K" .CommonData::$DDNS_RUN_SCRIPT))
        unlink("/etc/init.d/K" .CommonData::$DDNS_RUN_SCRIPT);

	if($enable=="enable")
	{
        file_put_contents("/etc/init.d/S" .CommonData::$DDNS_RUN_SCRIPT, $ddns_content);
        shell_exec("chmod +x " ."/etc/init.d/S" .CommonData::$DDNS_RUN_SCRIPT);
	}else
	{
        file_put_contents("/etc/init.d/K" .CommonData::$DDNS_RUN_SCRIPT, $ddns_content);
	}
}


//-- set DDNS configure
if($_POST["submit"]=="Modify")	//press "Modify" button
{
	$server = $_POST["server"];
	$domain = $_POST["domain"];
	$username = $_POST["username"];
	$password = $_POST["password"];
	$period = strval(intval($_POST["period"]));
	$enable = $_POST["enable"];

	setddnsCfg($server, $domain, $username, $password, $period, $enable);
	echo "<div align=\"center\"><font color=\"#cc0000\">setting success!!</font><br>\n";
	echo "<div align=\"center\"><font color=\"#cc0000\">Please reboot to enable setting!!</font><br>\n";
}else
{
	//-- ddns config : server, domain, user, password, period
	getddnsCfg($server, $domain, $username, $password, $period, $enable);
}

?>


	<br>
	<form method="post" name="form1"><br><!-- 加入 action="aa.html" 可以指定給誰處理 -->
		<table align="center" border="1" cellpadding="2" cellspacing="2" width="600">
		<tbody>

		<tr align="center">
			<td colspan="2" bgcolor="#ffcc99">DDNS Configure<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff" width="200">Server</td>
			<td >
				<select name="server">
				<option <?php if($server == "dyndns@dyndns.org") echo "selected"; ?> >dyndns@dyndns.org</option>
				<option <?php if($server == "default@freedns.afraid.org") echo "selected"; ?> >default@freedns.afraid.org</option>
				<option <?php if($server == "default@zoneedit.com") echo "selected"; ?> >default@zoneedit.com</option>
				<option <?php if($server == "default@no-ip.com") echo "selected"; ?> >default@no-ip.com</option>
				</select>
			<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Domain</td>
			<td ><input size="20" name="domain" value="<?php echo $domain;?>" ><br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Username</td>
			<td ><input size="20" name="username" value="<?php echo $username;?>" ><br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Password</td>
			<td ><input size="20" name="password" value="<?php echo $password;?>" ><br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Period</td>
			<td ><input size="20" name="period" value="<?php echo $period;?>" > seconds<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Enable</td>
			<td ><input size="20" name="enable" type="checkbox" value="enable"<?php if($enable=="enable") echo "checked";?> >Enable <br>
			</td>
		</tr>

		<tr align="center">
			<td colspan="2"><input name="submit" value="Modify" type="submit"><br>
			</td>
		</tr>

		</tbody>
		</table>

		<br>
		<br>
	</form>
	<br>
	<br>
</body>
</html>



