<?php
//==============================
//== show Network information ==
//==============================

require_once("./class.php");

getNetInfo($net_info);
getModemSta($modem_sta);

?>

<html>
<head>
<meta content="text/html; charset=UTF-8" http-equiv="content-type">
<title></title>
</head>

<body>
	<br>
		<table align="center" border="1" cellpadding="2" cellspacing="2" width="600">
		<tbody>

			<tr align="center">
				<td colspan="2" bgcolor="#ffcc99">Ethernet<br></td>
			</tr>

			<tr>
				<td bgcolor="#ccffff" width="200">Mode</td>
				<td ><?php echo $net_info["eth0_mode"]; ?><br></td>
			</tr>

			<tr>
				<td bgcolor="#ccffff">MAC address</td>
				<td ><?php echo $net_info["eth0_mac"]; ?><br></td>
			</tr>

			<tr>
				<td bgcolor="#ccffff">IP Address</td>
				<td ><?php echo $net_info["eth0_ip"]; ?><br></td>
			</tr>

			<tr>
				<td bgcolor="#ccffff">Mask</td>
				<td ><?php echo $net_info["eth0_mask"]; ?><br></td>
			</tr>

		</tbody>
		</table>
		<br>
		<br>


		<table align="center" border="1" cellpadding="2" cellspacing="2" width="600">
		<tbody>

			<tr align="center">
				<td colspan="2" bgcolor="#ffcc99">3G/GPRS Network information<br></td>
			</tr>

			<tr>
				<td bgcolor="#ccffff" width="200">Status</td>
				<td ><?php echo $net_info["ppp0_conn"]; ?><br></td>
			</tr>

			<tr>
				<td bgcolor="#ccffff">IP Address</td>
				<td >
				<?php
					if($net_info["ppp0_ip"]=="")
						echo "--";
					else
						echo $net_info["ppp0_ip"];
				?>
				</td>
			</tr>

			<tr>
				<td bgcolor="#ccffff">P-t-P</td>
				<td >
				<?php
					if($net_info["ppp0_ptp"]=="")
						echo "--";
					else
						echo $net_info["ppp0_ptp"];
				?>
				</td>
			</tr>

			<tr>
				<td bgcolor="#ccffff">Mask</td>
				<td >
				<?php
					if($net_info["ppp0_mask"]=="")
						echo "--";
					else
						echo $net_info["ppp0_mask"];
				?>
				</td>
			</tr>

		</tbody>
		</table>
		<br>
		<br>

		<table align="center" border="1" cellpadding="2" cellspacing="2" width="600">
		<tbody>

			<tr align="center">
				<td colspan="2" bgcolor="#ffcc99">Modem information<br></td>
			</tr>

			<tr>
				<td bgcolor="#ccffff" width="200">PIN Code</td>
				<td >
				<?php
					if($modem_sta["modem_cpin"]=="")
						echo "--";
					else
						echo $modem_sta["modem_cpin"];
				  ?>
				  </td>
			</tr>

			<tr>
				<td bgcolor="#ccffff">Register Status</td>
				<td >
				<?php
					switch($modem_sta["modem_creg"])
					{
					case "0":
						echo "Not Registered";
						break;
					case "1":
						echo "Registered";
						break;
					case "2":
						echo "Not Registered, but searching";
						break;
					case "3":
						echo "Registration denied";
						break;
					case "5":
						echo "Registered, roaming";
						break;
					default:
						echo "Not Registered, unknown";
					}
				?>
				</td>
			</tr>

			<tr>
				<td bgcolor="#ccffff">Signal Quality</td>
				<td >
				<?php
					$sig = intval($modem_sta["modem_csq"]);
					if($sig>=0 && $sig<=32)
						echo intval($sig/32*100) ."%";
					else
						echo "0%";
				?>
				</td>
			</tr>

		</tbody>
		</table>
		<br>
		<br>


		<table align="center" border="1" cellpadding="2" cellspacing="2" width="600">
		<tbody>

			<tr align="center">
				<td colspan="2" bgcolor="#ffcc99">VPN Network information<br></td>
			</tr>

			<tr>
				<td bgcolor="#ccffff" width="200">Status</td>
				<td ><?php echo $net_info["ppp1_conn"]; ?><br></td>
			</tr>

			<tr>
				<td bgcolor="#ccffff">IP Address</td>
				<td >
				<?php
					if($net_info["ppp1_ip"]=="")
						echo "--";
					else
						echo $net_info["ppp1_ip"];
				?>
				</td>
			</tr>

			<tr>
				<td bgcolor="#ccffff">P-t-P</td>
				<td >
				<?php
					if($net_info["ppp1_ptp"]=="")
						echo "--";
					else
						echo $net_info["ppp1_ptp"];
				?>
				</td>
			</tr>

			<tr>
				<td bgcolor="#ccffff">Mask</td>
				<td >
				<?php
					if($net_info["ppp1_mask"]=="")
						echo "--";
					else
						echo $net_info["ppp1_mask"];
				?>
				</td>
			</tr>

		</tbody>
		</table>
		<br>
		<br>

</body>
</html>

