<?php
require_once("../page/class.php");

//true表示array型態，false則是物件
$rtuJson = json_decode(file_get_contents(CommonData::$RTUC_CONFIG),false);
$mbNumber = $rtuJson->mbNumber;

for ($i = 0;$i <= $mbNumber;$i++)
{//最後一個給"Add"按鈕使用，後續處理時只要Device Name為空就代表「不新增」
	//ai與ao Type不管Array
	$aiType = $rtuJson->aiType[$i][0];
	$aoType = $rtuJson->aoType[$i][0];
	$mbDisplay .= '
	<tr id="mbList'.$i.'"'. (($i==$mbNumber || $i==0)?' style="display:none"':''). '>
		<td bgcolor="#ccffff" align="center" style="width:50px;">'.$i.'</td>
		<td bgcolor="#ccffff">Name : '.$rtuJson->mbName[$i].'</td>
		<td align="center">
			<input id="editButton'.$i.'" type="button" value="Edit" OnClick="editItem('.$i.');">
			<input id="deleteButton'.$i.'" type="button" value="Delete" OnClick="deleteItem('.$i.');">
			<input id="mbClick'.$i.'" type="hidden" value="0">
		</td>
	</tr>
	<tr id="mb'.$i.'" style="display:none">
		<td colspan="3">
			<table align="center" border="1" cellpadding="1" cellspacing="1" width="580">
				<tr>
					<td bgcolor="#ccffff">Device Name</td>
					<td><input size="20" id="mbName'.$i.'" name="mbName'.$i.'" value="'.$rtuJson->mbName[$i].'" maxlength=20
                        onkeyup="this.value=this.value.replace(/[^a-zA-Z0-9_\-]/g,\'\')">Max Length=20</td>
				</tr>
				<tr>
					<td bgcolor="#ccffff">Device ID</td>
					<td><input size="20" id="mbId'.$i.'" name="mbId'.$i.'" value="'.$rtuJson->mbId[$i].'">
                        1~255</td>
				</tr>
				<tr>
					<td bgcolor="#ccffff">IP</td>
					<td><input size="20" id="mbIp'.$i.'" name="mbIp'.$i.'" value="'.$rtuJson->mbIp[$i].'">
                        empty for Modbus/RTU</td>
				</tr>
				<tr>
					<td bgcolor="#ccffff">Port</td>
					<td><input size="20" id="mbPort'.$i.'" name="mbPort'.$i.'" value="'.$rtuJson->mbPort[$i].'" maxlength=5
                        onkeyup="this.value=this.value.replace(/[^0-9]/g,\'\')">
                        Default=502, 1~65535</td>
				</tr>
				<tr>
					<td bgcolor="#ccffff">DI Number</td>
					<td><input size="20" id="diN'.$i.'" name="diN'.$i.'" value="'.$rtuJson->diN[$i].'">
                        0~32</td>
				</tr>
				<tr>
					<td bgcolor="#ccffff">DO Number</td>
					<td><input size="20" id="doN'.$i.'" name="doN'.$i.'" value="'.$rtuJson->doN[$i].'">
                        0~32</td>
				</tr>
				<tr>
					<td bgcolor="#ccffff">AI Number</td>
					<td><input size="20" id="aiN'.$i.'" name="aiN'.$i.'" value="'.$rtuJson->aiN[$i].'">
                        0~16</td>
				</tr>
				<tr>
					<td bgcolor="#ccffff">AO Number</td>
					<td><input size="20" id="aoN'.$i.'" name="aoN'.$i.'" value="'.$rtuJson->aoN[$i].'">
                        0~16</td>
				</tr>
				<tr style="display:none">
					<td bgcolor="#ccffff">Counter Number</td>
					<td><input size="20" id="cntN'.$i.'" name="cntN'.$i.'" value="'.$rtuJson->cntN[$i].'">
                        0~16</td>
				</tr>
				<tr>
					<td bgcolor="#ccffff">DI Address</td>
					<td><input size="20" id="diAddress'.$i.'" name="diAddress'.$i.'" value="'.$rtuJson->diAddress[$i].'">
                        0~65535</td>
				</tr>
				<tr>
					<td bgcolor="#ccffff">DO Address</td>
					<td><input size="20" id="doAddress'.$i.'" name="doAddress'.$i.'" value="'.$rtuJson->doAddress[$i].'">
                        0~65535</td>
				</tr>
				<tr>
					<td bgcolor="#ccffff">AI Address</td>
					<td><input size="20" id="aiAddress'.$i.'" name="aiAddress'.$i.'" value="'.$rtuJson->aiAddress[$i].'">
                        0~65535</td>
				</tr>
				<tr>
					<td bgcolor="#ccffff">AO Address</td>
					<td><input size="20" id="aoAddress'.$i.'" name="aoAddress'.$i.'" value="'.$rtuJson->aoAddress[$i].'">
                        0~65535</td>
				</tr>
				<tr style="display:none">
					<td bgcolor="#ccffff">Counter Address</td>
					<td><input size="20" id="cntAddress'.$i.'" name="cntAddress'.$i.'" value="'.$rtuJson->cntAddress[$i].'">
                        0~65535</td>
				</tr>
				<tr style="display:none">
					<td bgcolor="#ccffff">AI Type (ICPDAS only)</td>
					<td><input size="20" id="aiType'.$i.'" name="aiType'.$i.'" value="'.$aiType.'">
                        0~255</td>
				</tr>
				<tr style="display:none">
					<td bgcolor="#ccffff">AO Type (ICPDAS only)</td>
					<td><input size="20" id="aoType'.$i.'" name="aoType'.$i.'" value="'.$aoType.'">
                        0~255</td>
				</tr>
				<tr style="display:none">
					<td bgcolor="#ccffff">AI Format (ICPDAS only)</td>
					<td><input size="20" id="aiFormat'.$i.'" name="aiFormat'.$i.'" value="'.$rtuJson->aiFormat[$i].'">
                        0~255</td>
				</tr>
				<tr style="display:none">
					<td bgcolor="#ccffff">AO Format (ICPDAS only)</td>
					<td><input size="20" id="aoFormat'.$i.'" name="aoFormat'.$i.'" value="'.$rtuJson->aoFormat[$i].'">
                        0~255</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr id="modify'.$i.'" align="center" style="display:none">
		<td colspan="3">
			<input name="button'.$i.'" value="Modify" type="button" onClick="validateForm('.$i.')">
			<input name="cancel" value="Cancel" type="button" onClick="cancelAction()">
		</td>
	</tr>
	';
}

?>
<html>
<head>
<meta content="text/html; charset=UTF-8" http-equiv="content-type">
<title></title>
<script src="js/jquery-1.6.1.js" type="text/javascript"></script>
<style type="text/css">
	.bg_d {
		background-color: #ffcc99;
		color: #000000;
		cursor: pointer;
	}
	.bg_l {
		background-color: #ffe6cc;
		color: #9f9f9f;
	}
</style>
<script type="text/javascript">
    //- table for M-7k
    // [name, diN, doN, aiN, aoN, diAddr, doAddr, aiAddr, aoAddr]
    var mbTable = [
        ['Custom',0,0,0,0,0,0,0,0],
        ['ET-7002',6,3,3,0,0,0,0,0],
        ['ET-7005',0,4,8,0,0,0,0,0],
        ['ET-7015',0,0,7,0,0,0,0,0],
        ['ET-7016',2,2,2,1,0,0,0,0],
        ['ET-7017',0,4,8,0,0,0,0,0],
        ['ET-7017-10',0,0,10,0,0,0,0,0],
        ['ET-7018',0,6,10,0,0,0,0,0],
        ['ET-7019',0,4,8,0,0,0,0,0],
        ['ET-7024',5,5,0,4,0,0,0,0],
        ['ET-7026',2,2,6,2,0,0,0,0],
        ['ET-7028',0,0,0,8,0,0,0,0],
        ['ET-7042',0,16,0,0,0,0,0,0],
        ['ET-7044',8,8,0,0,0,0,0,0],
        ['ET-7050',12,6,0,0,0,0,0,0],
        ['ET-7051',16,0,0,0,0,0,0,0],
        ['ET-7052',8,8,0,0,0,0,0,0],
        ['ET-7053',16,0,0,0,0,0,0,0],
        ['ET-7055',8,8,0,0,0,0,0,0],
        ['ET-7060',6,6,0,0,0,0,0,0],
        ['ET-7065',6,6,0,0,0,0,0,0],
        ['ET-7066',0,8,0,0,0,0,0,0],
        ['ET-7067',0,8,0,0,0,0,0,0],
        ['M-7002', 5, 4, 4, 0, 32, 0, 0, 0],
        ['M-7005', 0, 6, 8, 0, 0, 0, 0, 0],
        ['M-7011', 1, 2, 1, 0, 0, 32, 0, 0],
        ['M-7015', 0, 0, 6, 0, 0, 0, 0, 0],
        ['M-7016', 1, 4, 2, 1, 0, 32, 0, 32],
        ['M-7017', 0, 0, 8, 0, 0, 0, 0, 0],
        ['M-7018R', 0, 0, 8, 0, 0, 0, 0, 0],
        ['M-7019R', 0, 0, 8, 0, 0, 0, 0, 0],
        ['M-7022', 0, 0, 0, 2, 0, 0, 0, 0],
        ['M-7024', 0, 0, 0, 4, 0, 0, 0, 0],
        ['M-7026', 3, 3, 6, 2, 32, 0, 0, 32],
        ['M-7033', 0, 0, 3, 0, 0, 0, 0, 0],
        ['M-7041', 14, 0, 0, 0, 0, 0, 0, 0],
        ['M-7045', 0, 16, 0, 0, 0, 0, 0, 0],
        ['M-7050', 7, 8, 0, 0, 0, 0, 0, 0],
        ['M-7051', 16, 0, 0, 0, 0, 0, 0, 0],
        ['M-7052', 8, 0, 0, 0, 0, 0, 0, 0],
        ['M-7053', 16, 0, 0, 0, 0, 0, 0, 0],
        ['M-7055', 8, 8, 0, 0, 0, 0, 0, 0],
        ['M-7060', 4, 4, 0, 0, 0, 0, 0, 0],
        ['M-7080B', 0, 2, 2, 0, 0, 0, 0, 0],
        ];
	function  AddItem()
	{
        //AddItem --> modifyNumber = mbNumber
		var mbNumber = $("#mbNumber").val();
		var val = mbNumber;
		$("#modifyNumber").val(val); //更新目前item id
		//先將其他button disable
		$("#addButton").attr("disabled", true);
		$("#icpdasMbList").attr("disabled", true);
		for (var i = 0;i <= mbNumber;i++){
			$("#editButton"+i).attr("disabled", true);
			$("#deleteButton"+i).attr("disabled", true);
		}

        //- put io setting
        mbIndex = 0;
        selectedItem = $("#icpdasMbList").val();
        for(i=0; i<mbTable.length; i++)
        {
            if(mbTable[i][0] == selectedItem)
            {
                mbIndex = i;
                break;
            }
        }
		var mbClick = $("#mbClick"+val).val();
		if (mbClick == "0"){
			$("#modify"+val).css("display","");
			$("#mb"+val).show("slow");
			$("#mbClick"+val).val("1");
			$("#mbList"+val).css("display","");
			//-- 把M-7k, ET-7k的設定值填入
			$("#mbName"+val).attr("value", mbNumber+"_"+mbTable[mbIndex][0]);
			$("#mbId"+val).attr("value", 1);
			//- net data
			if(mbTable[mbIndex][0].indexOf("M-7")>=0)//M-7k
			{
                $("#mbIp"+val).attr("value", "");
                $("#mbIp"+val).attr("readonly", true);//true好像會送不出去，待查
                $("#mbPort"+val).attr("readonly", true);
            }
            else//ET-7k
            {
                $("#mbIp"+val).attr("value", "192.168.1.1");
                $("#mbIp"+val).attr("disabled", false);
                $("#mbPort"+val).attr("disabled", false);
            }
			$("#mbPort"+val).attr("value", 502);
			//- IO data
			$("#diN"+val).attr("value", mbTable[mbIndex][1]);
			$("#doN"+val).attr("value", mbTable[mbIndex][2]);
			$("#aiN"+val).attr("value", mbTable[mbIndex][3]);
			$("#aoN"+val).attr("value", mbTable[mbIndex][4]);
			$("#cntN"+val).attr("value", 0);
            //- address
			$("#diAddress"+val).attr("value", mbTable[mbIndex][5]);
			$("#doAddress"+val).attr("value", mbTable[mbIndex][6]);
			$("#aiAddress"+val).attr("value", mbTable[mbIndex][7]);
			$("#aoAddress"+val).attr("value", mbTable[mbIndex][8]);
			$("#cntAddress"+val).attr("value", 0);
            //- AIO type
			$("#aiType"+val).attr("value", "255");
			$("#aoType"+val).attr("value", "255");
			$("#aiFormat"+val).attr("value", "255");
			$("#aoFormat"+val).attr("value", "255");

		}else {
			$("#modify"+val).css("display","none");
			$("#mb"+val).hide("fast");
			$("#mbClick"+val).val("0");
			$("#mbList"+val).css("display","none");
		}
	}
	function  editItem(val)
	{
		var mbNumber = $("#mbNumber").val();
		$("#modifyNumber").val(val); //更新目前item id
		//先將其他button disable
		$("#addButton").attr("disabled", true);
		for (var i = 0;i <= mbNumber;i++){
			$("#editButton"+i).attr("disabled", true);
			$("#deleteButton"+i).attr("disabled", true);
		}

		var mbClick = $("#mbClick"+val).val();
		if (mbClick == "0"){
			$("#modify"+val).css("display","");
			$("#mb"+val).show("slow");
			$("#mbClick"+val).val("1");
		}else {
			$("#modify"+val).css("display","none");
			$("#mb"+val).hide("fast");
			$("#mbClick"+val).val("0");
		}
	}
	function deleteItem(val)
	{
		if (confirm("Do you sure to delete?")) {
			$("#modifyNumber").val(val); //更新目前item id
			$("#modifyType").val("mbnumber_delete");
			document.forms["mbnumber_para"].submit();
		}else {
			return false;
		}
	}
	function  cancelAction()
	{
		//reload page即可
		window.location.href='fw_rtuc_mbnumber.php';
	}

	function validateForm(thisNum)
	{
        var mbNumber = $("#mbNumber").val();

        if($("#mbName"+thisNum).val()=="")//-->if mbName is empty --> not "Add Button"
        {
            alert('Name cannot be empty');
            $("#mbName"+thisNum).focus();
            return;
        }

        //名字不能重覆
        if(mbNumber>1)
        {
            for (n = 1;n <= mbNumber;n++)
            {
                if(n!=thisNum && $("#mbName"+thisNum).val()==$("#mbName"+n).val())
                {
                    alert('Name conflicts with device['+n+']');
                    $("#mbName"+thisNum).focus();
                    return;
                }
            }
        }

        if($("#mbId"+thisNum).val()>255 || $("#mbId"+thisNum).val()<1)
        {
            alert('Device ID = 1~255');
            $("#mbId"+thisNum).focus();
            return;
        }
        //待加入mbIp的判斷
        if($("#mbPort"+thisNum).val()>65535 || $("#mbPort"+thisNum).val()<1)
        {
            alert('Port = 1~65535'+', Port['+thisNum+']='+$("#mbPort"+thisNum).val());
            $("#mbPort"+thisNum).focus();
            return;
        }
        if($("#diN"+thisNum).val()>32 || $("#diN"+thisNum).val()<0)
        {
            alert('DI Number = 0~32');
            $("#diN"+thisNum).focus();
            return;
        }
        if($("#doN"+thisNum).val()>32 || $("#doN"+thisNum).val()<0)
        {
            alert('DO Number = 0~32');
            $("#doN"+thisNum).focus();
            return;
        }
        if($("#aiN"+thisNum).val()>16 || $("#aiN"+thisNum).val()<0)
        {
            alert('AI Number = 0~16');
            $("#aiN"+thisNum).focus();
            return;
        }
        if($("#aoN"+thisNum).val()>16 || $("#aoN"+thisNum).val()<0)
        {
            alert('AO Number = 0~16');
            $("#aoN"+thisNum).focus();
            return;
        }
        if($("#cntN"+thisNum).val()>16 || $("#cntN"+thisNum).val()<0)
        {
            alert('Counter Number = 0~16');
            $("#cntN"+thisNum).focus();
            return;
        }
        if($("#diAddress"+thisNum).val()>65535 || $("#diAddress"+thisNum).val()<0)
        {
            alert('DI Address = 0~65535');
            $("#diAddress"+thisNum).focus();
            return;
        }
        if($("#doAddress"+thisNum).val()>65535 || $("#doAddress"+thisNum).val()<0)
        {
            alert('DO Address = 0~65535');
            $("#doAddress"+thisNum).focus();
            return;
        }
        if($("#aiAddress"+thisNum).val()>65535 || $("#aiAddress"+thisNum).val()<0)
        {
            alert('AI Address = 0~35535');
            $("#aiAddress"+thisNum).focus();
            return;
        }
        if($("#aoAddress"+thisNum).val()>65535 || $("#aoAddress"+thisNum).val()<0)
        {
            alert('AO Address = 0~65535');
            $("#aoAddress"+thisNum).focus();
            return;
        }
        if($("#cntAddress"+thisNum).val()>65535 || $("#cntAddress"+thisNum).val()<0)
        {
            alert('Counter Address = 0~65535');
            $("#cntAddress"+thisNum).focus();
            return;
        }
        if($("#aiType"+thisNum).val()>255)
        {
            alert('AI Type = 0~255');
            $("#aiType"+thisNum).focus();
            return;
        }
        if($("#aoType"+thisNum).val()>255)
        {
            alert('AO Type = 0~255');
            $("#aoType"+thisNum).focus();
            return;
        }
        if($("#aiFormat"+thisNum).val()>255)
        {
            alert('AI Format = 0~255');
            $("#aiFormat"+thisNum).focus();
            return;
        }
        if($("#aoFormat"+thisNum).val()>255)
        {
            alert('AO Format = 0~255');
            $("#aoFormat"+thisNum).focus();
            return;
        }

		document.forms["mbnumber_para"].submit();
	}

</script>
<script type="text/javascript">
	$(function() {
		$(".bg_l").hover(function() {
  			$(this).css("background-color","#ffcc99");
  			$(this).css("color","#000000");
  			$(this).css("cursor","pointer");
  		},function(){
  			$(this).css('background-color','#ffe6cc');
  			$(this).css("color","#9f9f9f");
  			$(this).css("cursor","auto");
  		});

		$("#page1").click(function(){
			window.location.href='fw_rtuc.php';
		});
		$("#page2").click(function(){
			window.location.href='fw_rtuc_mbnumber.php';
		});
		$("#page3").click(function(){
			window.location.href='fw_rtuc_otherpara.php';
		});
	});
</script>
</head>

<body>
	<br>
	<form id="mbnumber_para" name="mbnumber_para" method="post" action="fw_rtuc_action.php"><br>
		<table align="center" border="1" cellpadding="2" cellspacing="2" width="600">
			<tbody>
				<tr align="center">
					<td id="page1" class="bg_l">Main Info.</td>
					<td id="page2" class="bg_d">Modbus Device</td>
					<td id="page3" class="bg_l">FTP / Email</td>
				</tr>
			</tbody>
		</table>
		<table align="center" border="1" cellpadding="2" cellspacing="2" width="600">
		<tbody>

		<!-- Modbus/TCP, RTU parameter -->

		<tr>
			<td bgcolor="#ccffff" style="width:200px;" colspan="2">
				Modbus Device Number :	<?php echo ($mbNumber-1);?>
			</td>
			<td align="center">
                <?php
                if($mbNumber<=10)
                    echo '<input id="addButton" type="button" value="Add" OnClick="AddItem()">';
                else
                    echo '<input id="addButton" type="button" value="Add" OnClick="AddItem()" disabled="disabled">';
				?>
				<input id="modifyNumber" name="modifyNumber" type="hidden" value="" >
				<input id="modifyType" name="modifyType" type="hidden" value="mbnumber">
				<input id="mbNumber" name="mbNumber" type="hidden" value="<?php echo $mbNumber;?>">

				<select id="icpdasMbList" name="icpdasMbList">
				<option selected>Custom</option>
				<script type="text/javascript">
                    for(i=0; i<mbTable.length; i++)
                    {
                        if(mbTable[i][0] == "Custom") continue;
                        document.write("<option >" + mbTable[i][0]+"</option>");
                    }
				</script>
				<?php
                    foreach($mbData as $item)
                    {
                        echo "<option >" .$item["name"] ."</option>";
                    }
				?>
				</select>

			</td>
		</tr>
		<?php echo $mbDisplay;?>
		<tr id="afterItem"></tr>
		</tbody>
		</table>
	</form>

</body>
</html>
