import modbus_tk
import modbus_tk.defines as cst
import modbus_tk.modbus_rtu as modbus_rtu
import modbus_tk.modbus_tcp as modbus_tcp
import serial

from libRTU import *
import json
import csv

"""
    v1.0.1 2014/12/12 fix E71 configure not work problem, by malo
"""

def filter_data(obj):
    """
    for json.loads(). to solve the problem loads() will return "unicode string"
    """
    if type(obj) in (int, float, str, bool):
            return obj
    elif type(obj) == unicode:
            return str(obj)
    elif type(obj) in (list, tuple, set):
            obj = list(obj)
            for i,v in enumerate(obj):
                    obj[i] = filter_data(v)
    elif type(obj) == dict:
            for i,v in obj.iteritems():
                    obj[i] = filter_data(v)
    else:
            print "invalid object in data, converting to string"
            obj = str(obj)
    return obj

class RtuClient_Modbus(RtuClient):
    '''RTU Client Class with Modbus/TCP
    using poll_modbus() to get data from Modbus'''

    #### Start
    #-- be hard to group those paramter, so put here
    # ftp function parameters
    ftp_serverAddr = 'localhost'
    ftp_port = 21
    ftp_username = 'test'
    ftp_password = 'test'
    ftp_enable = 'disable'
    # email parameters
    email_fromMail = 'malo.grp@gmail.com'
    email_toMails = 'yguma.yang@gmail.com'
    email_mailServer = 'smtp.gmail.com'
    email_mailPort = 25 #587
    email_username = 'malo.grp'
    email_password = 'icpdasicpdas'
    email_enable = 'disable'
    email_max_size = 3000000;
    #--
    rtuc_config_file = 'rtuc.ini'
    #### End


    def saveConfig(self, FFN=None):
        """
        FFN: Full File Name
        """
        rtuConfig = dict()
        rtuConfig['serverIp'] = self.serverIp
        rtuConfig['serverPort'] = self.serverPort

        # Modbus parameter
        rtuConfig['buadrate'] = self.baudrate
        rtuConfig['databit'] = self.databit
        rtuConfig['parity'] = self.parity
        rtuConfig['stopbit'] = self.stopbit
        rtuConfig['mbTimeout'] = self.mbTimeout

        rtuConfig['logTime'] = self.logTime
        rtuConfig['logChangeTime'] = self.logChangeTime

        rtuConfig['stationId'] = self.stationId
        rtuConfig['deviceType'] = self.deviceType
        rtuConfig['dataTime'] = self.dataTime
        rtuConfig['heartTime'] = self.heartTime

        # Modbus/TCP, RTU parameter
        rtuConfig['mbNumber'] = self.mbNumber
        rtuConfig['mbName'] = self.mbName
        rtuConfig['mbId'] = self.mbId
        rtuConfig['mbIp'] = self.mbIp
        rtuConfig['mbPort'] = self.mbPort
        rtuConfig['diN'] = self.diN
        rtuConfig['doN'] = self.doN
        rtuConfig['aiN'] = self.aiN
        rtuConfig['aoN'] = self.aoN
        rtuConfig['cntN'] = self.cntN
        rtuConfig['diAddress'] = self.diAddress
        rtuConfig['doAddress'] = self.doAddress
        rtuConfig['aiAddress'] = self.aiAddress
        rtuConfig['aoAddress'] = self.aoAddress
        rtuConfig['cntAddress'] = self.cntAddress

        #- data field (initial packet)
        rtuConfig['aiType'] = self.aiType
        rtuConfig['aoType'] = self.aoType
        rtuConfig['aiFormat'] = self.aiFormat
        rtuConfig['aoFormat'] = self.aoFormat


        #- log Folder
        rtuConfig['log_dir'] = self.log_dir
        rtuConfig['log_ftpDir'] = self.log_ftpDir
        rtuConfig['log_mailDir'] = self.log_mailDir

        # FTP parameter
        rtuConfig['ftp_serverAddr'] = self.ftp_serverAddr
        rtuConfig['ftp_port'] = self.ftp_port
        rtuConfig['ftp_username'] = self.ftp_username
        rtuConfig['ftp_password'] = self.ftp_password

        # E-mail parameter
        rtuConfig['email_fromMail'] = self.email_fromMail
        rtuConfig['email_toMails'] = self.email_toMails
        rtuConfig['email_mailServer'] = self.email_mailServer
        rtuConfig['email_mailPort'] = self.email_mailPort
        rtuConfig['email_username'] = self.email_username
        rtuConfig['email_password'] = self.email_password

        if (FFN==None):
            with open(self.rtuc_config_file, 'wb') as fp:
                json.dump(rtuConfig, fp)
        else:
            with open(FFN, 'wb') as fp:
                json.dump(rtuConfig, fp)


    def readConfig(self, FFN=None):
        """
        FFN: Full File Name, if None --> default file "rtuc.ini"
        """
        if (FFN==None):
            with open(self.rtuc_config_file, 'rb') as fp:
                #rtuConfig = json.load(fp)
                rtuConfig = json.load(fp, object_hook=filter_data)
        else:
            with open(FFN, 'wb') as fp:
                rtuConfig = json.load(fp, object_hook=filter_data)


        self.serverIp = rtuConfig['serverIp']
        self.serverPort = rtuConfig['serverPort']

        # Modbus parameter
        self.baudrate = rtuConfig['buadrate']
        self.databit = rtuConfig['databit']
        self.parity = rtuConfig['parity']
        self.stopbit = rtuConfig['stopbit']
        self.mbTimeout = rtuConfig['mbTimeout']

        self.logTime = rtuConfig['logTime']
        self.logChangeTime = rtuConfig['logChangeTime']

        self.stationId = rtuConfig['stationId']
        self.deviceType = rtuConfig['deviceType']
        self.dataTime = rtuConfig['dataTime']
        self.heartTime = rtuConfig['heartTime']

        # Modbus/TCP, RTU parameter
        self.mbNumber = rtuConfig['mbNumber']
        self.mbName = rtuConfig['mbName']
        self.mbId = rtuConfig['mbId']
        self.mbIp = rtuConfig['mbIp']
        self.mbPort = rtuConfig['mbPort']
        self.diN = rtuConfig['diN']
        self.doN = rtuConfig['doN']
        self.aiN = rtuConfig['aiN']
        self.aoN = rtuConfig['aoN']
        self.cntN = rtuConfig['cntN']
        self.diAddress = rtuConfig['diAddress']
        self.doAddress = rtuConfig['doAddress']
        self.aiAddress = rtuConfig['aiAddress']
        self.aoAddress = rtuConfig['aoAddress']
        self.cntAddress = rtuConfig['cntAddress']

        #- data field (initial packet)
        self.aiType = rtuConfig['aiType']
        self.aoType = rtuConfig['aoType']
        self.aiFormat = rtuConfig['aiFormat']
        self.aoFormat = rtuConfig['aoFormat']

        #- data field (data packet)
        self.isValid = [0]*self.mbNumber #is MB data valid
        self.di = [0]*self.mbNumber
        self.do = [0]*self.mbNumber
        self.ai = [0]*self.mbNumber
        self.ao = [0]*self.mbNumber
        self.cnt = [0]*self.mbNumber
        for i in range(self.mbNumber):
            self.di[i] = [0]*32
            self.do[i] = [0]*32
            self.ai[i] = [0]*32
            self.ao[i] = [0]*32
            self.cnt[i] = [0]*32
        self.gps = ''

        #- log Folder
        self.log_dir = rtuConfig['log_dir']
        self.log_ftpDir = rtuConfig['log_ftpDir']
        self.log_mailDir = rtuConfig['log_mailDir']

        # FTP parameter
        self.ftp_serverAddr = rtuConfig['ftp_serverAddr']
        self.ftp_port = rtuConfig['ftp_port']
        self.ftp_username = rtuConfig['ftp_username']
        self.ftp_password = rtuConfig['ftp_password']
        self.ftp_enable = rtuConfig['ftp_enable']

        # E-mail parameter
        self.email_fromMail = rtuConfig['email_fromMail']
        self.email_toMails = rtuConfig['email_toMails']
        self.email_mailServer = rtuConfig['email_mailServer']
        self.email_mailPort = rtuConfig['email_mailPort']
        self.email_username = rtuConfig['email_username']
        self.email_password = rtuConfig['email_password']
        self.email_enable = rtuConfig['email_enable']
        self.email_max_size = rtuConfig['email_max_size']


    def nameId(self, idx):
            return " [" + str(self.mbName[idx]) + "," + str(self.mbId[idx]) + '] '

    def poll_modbus(self):
        resultData = ''
        for idx in range(self.mbNumber):
            try:
                #if (self.mbIp==None or idx==0):#skip Modbus/RTU, and Local_IO
                if (idx==0):#skip Modbus/RTU, and Local_IO
                    continue

                if(self.mbIp[idx]==None or self.mbIp[idx]==""):
                    # Modbus/RTU Client Start
                    #self.logInfo("Modbus/RTU Client[%d] Start" %(idx))
                    mb_port = serial.Serial(port=self.mbComPort, baudrate=self.baudrate, bytesize=self.databit, parity=self.parity, stopbits=self.stopbit)
                    master = modbus_rtu.RtuMaster(mb_port)
                    master.set_timeout(self.mbTimeout/1000.0)
                else:
                    # Modbus/TCP Client Start
                    #self.logInfo("Modbus/TCP Client[%d] Start" %(idx))
                    master = modbus_tcp.TcpMaster(self.mbIp[idx], self.mbPort[idx])
                    master.set_timeout(self.mbTimeout/1000.0)

                #-- Send Request
                mbId = self.mbId[idx]
                if(self.diN[idx]>0):
                    #-- DI read: FC2  Read multi-input discrete ( 1xxxx )
                    rr = master.execute(mbId, cst.READ_DISCRETE_INPUTS, self.diAddress[idx], self.diN[idx])
                    for i in range(self.diN[idx]):
                        self.di[idx][i] = rr[i]
                    self.logDebug("[%d] DI value= %s" %(idx, rr))

                if(self.doN[idx]>0):
                    #-- FC01: Read multi-coils status (0xxxx) for DO
                    rr = master.execute(mbId, cst.READ_COILS, self.doAddress[idx], self.doN[idx])
                    for i in range(self.doN[idx]):
                        self.do[idx][i] = rr[i]
                    self.logDebug("[%d] DO value= %s" %(idx, rr))

                if(self.aiN[idx]>0):
                    #-- FC04: read multi-input registers (3xxxx), for AI
                    rr = master.execute(mbId, cst.READ_INPUT_REGISTERS, self.aiAddress[idx], self.aiN[idx])
                    for i in range(self.aiN[idx]):
                        self.ai[idx][i] = rr[i]
                    self.logDebug("[%d] AI value= %s" %(idx, rr))

                if(self.aoN[idx]>0):
                    #-- FC03: read multi-registers (4xxxx) for AO
                    rr = master.execute(mbId, cst.READ_HOLDING_REGISTERS, self.aoAddress[idx], self.aoN[idx])
                    for i in range(self.aoN[idx]):
                        self.ao[idx][i] = rr[i]
                    self.logDebug("[%d] AO value= %s" %(idx, rr))

                self.isValid[idx] = 1

                master._do_close()

            except Exception, e:
                #master._do_close()
                self.logError("MB[%d] poll_modbus(): %s" %(idx, e))
                resultData += (self.nameId(idx) + "Exception: " + str(e) + "\r\n")
                self.isValid[idx] = 0

        if(len(resultData)==0):
            return None
        else:
            return resultData

    #== deal the command from RTU Center
    def deal_command(self):
        """check command buffer. deal I/O command if there is any command in buffer"""
        resultData = ''
        #for cmd in self.rtuCmdList:
        while (len(self.rtuCmdList)>0):
            cmd = self.rtuCmdList.pop()
            try:
                cmd_type = cmd["type"]
                staID = cmd['staID']
                idx = cmd["index"]
                fc = cmd["FC"]
                ch = cmd['ch']
                value = cmd['value']

                if (idx==0):#skip Modbus/RTU, and Local_IO
                    continue

                if(self.mbIp[idx]==None or self.mbIp[idx]==""):
                    # Modbus/RTU Client Start
                    #self.logInfo("Modbus/RTU Client[%d] Start" %(idx))
                    mb_port = serial.Serial(port=self.mbComPort, baudrate=self.baudrate, bytesize=self.databit, parity=self.parity, stopbits=self.stopbit)
                    master = modbus_rtu.RtuMaster(mb_port)
                    master.set_timeout(self.mbTimeout/1000.0)
                else:
                    # Modbus/TCP Client Start
                    #self.logInfo("Modbus/TCP Client[%d] Start" %(idx))
                    master = modbus_tcp.TcpMaster(self.mbIp[idx], self.mbPort[idx])
                    master.set_timeout(self.mbTimeout/1000.0)

                if (cmd_type==0):#set DO/AO value, TODO:counter
                    if(fc==5):
                        #-- FC5:
                        rr = master.execute(self.mbId[idx], cst.WRITE_SINGLE_COIL, ch+self.doAddress[idx], output_value=value)
                        self.logInfo("[%d] Write(addr, value)=%s" %(idx, str(rr)))

                    elif (fc==6):
                        #-- FC6:
                        rr = master.execute(self.mbId[idx], cst.WRITE_SINGLE_REGISTER, ch+self.aoAddress[idx], output_value=value)
                        self.logInfo("[%d] Write(addr, value)=%s" %(idx, str(rr)))

                    elif (fc==15):
                        #-- FC15:
                        valueList = int2boolArray(value)
                        rr = master.execute(self.mbId[idx], cst.WRITE_MULTIPLE_COILS, ch+self.doAddress[idx], output_value=valueList)
                        self.logInfo("[%d] Write(addr, value)=%s" %(idx, str(rr)))

                    pass
                elif (cmd_type==1):#Utility command
                    self.logInfo("[%d] Utility command: not support" %(idx))
                    pass
                elif (cmd_type==2):#Counter command
                    self.logInfo("[%d] Counter command: not support" %(idx))
                    pass

                master._do_close()
            except Exception, e:
                self.logError("deal_command(): " + str(e))
                #master._do_close()
                pass



    def makeLog(self):
        """output log file, format as below:
            Date, local IO..., Mudule[name] Addr., IO..., etc...
            notice: use this function, please make sure your polling time <= 0.5
        """
        try:
            if(self.logTime==0):
                return None
            # Create log file and write title
            timeSeconds = time.time()
            localtime = time.localtime(timeSeconds)
            strDate = "%4d%02d%02d" %(localtime.tm_year, localtime.tm_mon, localtime.tm_mday)
            strTime = "%02d%02d%02d" %(localtime.tm_hour, localtime.tm_min, localtime.tm_sec)

            # (first time) or (change date) or (arrive change-log-time) --> change log file
            daySeconds = localtime.tm_hour*60*60 + localtime.tm_min*60 + localtime.tm_sec
            if( ((self.strDate!=strDate) or (daySeconds%self.logChangeTime==0) or
                    (self.logFileName!=None and
                    (self.email_enable=="enable" or self.ftp_enable=="enable") and
                    (os.path.getsize(self.logFileName) > self.email_max_size)) ) and
                (not self.isChangeLogFileFlag) ):

                if( (self.logFileName!=None) ): # first time logFileName==None
                    self.lastLogFileName = self.logFileName
                    self.isChangeLogFileFlag = True
                #GT-540_20131029_175000_30.csv
                self.logFileName = 'GRP-520_%d_%s_%s.csv' %(self.stationId, strDate, strTime)
                self.strDate = strDate
                logList = list()
                logList.append('Date')
                for i in range(self.mbNumber):
                    logList.append("Module["+self.mbName[i]+"] Addr.")
                    for j in range(self.diN[i]):
                        logList.append('DI'+str(j))
                    for j in range(self.doN[i]):
                        logList.append('DO'+str(j))
                    for j in range(self.aiN[i]):
                        logList.append('AI'+str(j))
                    for j in range(self.aoN[i]):
                        logList.append('AO'+str(j))
                    for j in range(self.cntN[i]):
                        logList.append('CI'+str(j))
                if(self.isGps):
                    logList.append('GPS Data(GPRMC)')
                with open(self.logFileName, 'wb') as f:
                    writer = csv.writer(f)
                    writer.writerow(logList)

            # write log data
            if (timeSeconds-self.lastLogTime>=self.logTime):
                self.lastLogTime = int(timeSeconds)

                logList = list()
                logList.append('%s %s' %(strDate, strTime))
                for i in range(self.mbNumber):
                    logList.append(self.mbId[i])
                    if(self.isValid[i]==1):
                        for j in range(self.diN[i]):
                            logList.append(self.di[i][j])
                        for j in range(self.doN[i]):
                            logList.append(self.do[i][j])
                        for j in range(self.aiN[i]):
                            logList.append(self.ai[i][j])
                        for j in range(self.aoN[i]):
                            logList.append(self.ao[i][j])
                        for j in range(self.cntN[i]):
                            logList.append(self.cnt[i][j])
                    else:
                        for j in range(self.diN[i]):
                            logList.append('bad')
                        for j in range(self.doN[i]):
                            logList.append('bad')
                        for j in range(self.aiN[i]):
                            logList.append('bad')
                        for j in range(self.aoN[i]):
                            logList.append('bad')
                        for j in range(self.cntN[i]):
                            logList.append('bad')

                if(self.isGps):
                    if(self.gpsLen>1):
                        logList.append(self.gps)
                    else:
                        logList.append(' ')
                with open(self.logFileName, 'ab') as f:
                    writer = csv.writer(f)
                    writer.writerow(logList)

        except Exception, e:
            return ' Data Log Error, ' + str(e)

    def isChangeLogFile(self):
        '''check Is new Log file created
        get last log file name from property "lastLogFileName"
        '''
        if(self.isChangeLogFileFlag):
            self.isChangeLogFileFlag = False
            return True
        else:
            return False


'''
#-- fill initial rtu data
rtuc = RtuClient_Modbus(3)
rtuc.serverIp = '192.168.27.40'
rtuc.serverPort = 10000
rtuc.stationId = 2
rtuc.deviceType = 0
rtuc.setMb(0, 'Local IO', 255, 0, 0, 0, 0, 0, [0], 0, [0], 0, 0, 0, 0, 0, 0)
rtuc.setMb(1, 'mb1', 1, 8, 8, 4, 8, 0, [0]*4, 0, [0]*8, 0, 0, 0, 0, 0, 0)
rtuc.isValid[1] = 1
rtuc.mbIp[1] = '192.168.27.67'
rtuc.mbPort[1] = 502

rtuc.setMb(2, 'mb2', 1, 2, 2, 2, 2, 0, [0]*2, 0, [0]*2, 0, 8, 8, 8, 8, 0)
rtuc.isValid[2] = 1
rtuc.mbIp[2] = '192.168.27.67'
rtuc.mbPort[2] = 502

#- debug
#rtuc.printAll()
#rtuc.enable_debug()
res = rtuc.poll_modbus()
#rtuc.printAll()
print res

'''