#!/usr/bin/php
<?php

$rebootLog = '/icpdas/rebootTimer/tm.log';
$rbHour = 0;  //reboot hour
$rbMinute = 0;//reboot minute

//-- read configure file
if($argc==1)
{
	$data=file_get_contents("/icpdas/rebootTimer/rebootTimer.ini");
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);
		if($line[0]=='#') continue;

		list($name , $value)=split('=' , $line);
		if($name == "rbHour")
		{
			$rbHour = ((int)$value);
		}
		else if($name == "rbMinute")
		{
			$rbMinute = ((int)$value);
		}
	}
}
if($argc>=2)
{
	if($argv[1]=="--help")
	{
		echo "Reboot system deamon. Reboot at configure time every\n";
		echo "Usage: rebootTimer [hour] [minute]\n";
		echo "  hour:    0~23 (default: 0)\n";
		echo "  minute:  0~59 (default: 0)\n";
		echo "  (version = v1.1.0 2015/01/08)\n";
	}else if($argv[1]=="--ver")
	{
        echo "version = v1.1.0 2015/01/08\n";
        return;
	}
	return;
}

echo "--> start, reboot time=" .$rbHour .":" .$rbMinute ."\n";
logTime("start, reboot time=" .$rbHour .":" .$rbMinute, $rebootLog);

while(1)
{
	// Prints something like: 2013/12/27 11:09:00
	echo "-->Now: [" .date('Y/m/d H:i:s') ."]\n";

	if( ($rbHour==(int)date('H')) && ($rbMinute==(int)date('i')) )
	{
		sleep(50);//避免多次重開
        logTime("reboot system", $rebootLog);
		echo "  reboot system\n";
		exec('reboot');
	}
	else
	{
		echo "  sleep\n";
		sleep(10);
	}
}

function logTime($message="", $logFile)
{
    $MAX_LINE = 1000;
    $info = file_get_contents($logFile);
    $info_array = explode("\n", $info);
    $lineNum = sizeof($info_array);
    //最多保留1000筆 (約10kB)
    if($lineNum<$MAX_LINE)
    {
        $info_array[] = ("[".date('Y/m/d H:i:s')."] " .$message );
    }else
    {
        $info_array = array_slice($info_array, -1*$MAX_LINE, $MAX_LINE);
        $info_array[] = ("[".date('Y/m/d H:i:s')."] " .$message );
    }
    $data=implode("\n",$info_array);
    file_put_contents($logFile,$data);
}

?>

