<?php
class CommonData
{
	//Information
	public static $INFO_MODEM_PROC = "/icpdas/bin/getModemInfo.exe";
	public static $INFOR_SN = "/icpdas/QC/sn_QC.exe";
	public static $OS_KERNEL_VER = "uname -r";
	public static $OS_VER = "uname -v";	//OS build version
	public static $CMDLINE_FILE = "/proc/cmdline";	//boot command line
	public static $OS_VER_FILE = "/icpdas/OS_Ver";	//OS version file

	//Netwrok
	public static $NETWORK_SETTING_PATH = "/etc/network/interfaces";
	public static $DNS_SETTING_PATH = "/etc/resolv.conf";
	public static $NAT_PATH = "/etc/init.d/S43nat";

	//pppd configuration  file
	public static $PPPD_PAP_SECRETS = "/etc/ppp/pap-secrets";
	public static $PPPD_CHAP_SECRETS = "/etc/ppp/chap-secrets";
	public static $PPPD_PEERS = "/etc/ppp/peers/3g";
	public static $PPPD_CHATSCRIPTS = "/etc/ppp/chatscripts/3g";
	public static $PPPD_UDEV_FILE = "/etc/udev/rules.d/30-pppd.rules";

	//modem configuration file
	public static $MODEM_INIT_SETTING_FILE = "/icpdas/config/init_modem";

	//ddns configuration file
	public static $DDNS_SETTING_FILE = "/etc/inadyn.conf";
	public static $DDNS_RUN_SCRIPT = "46ddns";	//不含"S"或"K"開頭

	//DHCP SERVER configuration file
	public static $DHCPD_SETTING_FILE = "/etc/dhcpd.conf";
	public static $DHCPD_RUN_SCRIPT = "52dhcpd";	//不含"S"或"K"開頭

	//Web Server password file
	public static $HTTPD_PASSWORD_FILE = "/etc/.httppasswd";

	//Process manager
	public static $SYSPROC_FILE = "/icpdas/config/proc_sys.list";
	public static $USERPROC_FILE = "/icpdas/config/proc_user.list";
	public static $USERPROC_DIR = "/icpdas/user_proc";
	public static $AUTORUN_FILE = "/etc/init.d/S90firmware";

	//DIR for Device parameter file
	public static $PARA_DIR = "/icpdas/httpd/para_out";
	public static $PARA_FILE = "webConfig.tar";
	public static $FACTORY_FILE = "/icpdas/httpd/para_out/webDefault.tar";

	//VxServer
	public static $VXSC_DIR = "/icpdas/vxsc";
	public static $VXSC_EXE = "vxsc.exe";
	//public static $VXSC_CONFIG = "vxserver.ini";
	public static $VXSC_CONFIG = "/icpdas/vxsc/vxserver.ini";

	//gprsMonitor
	public static $GPRSM_DIR = "/icpdas/gprsm";
	public static $GPRSM_EXE = "gprsMonitor.php";
	public static $GPRSM_CONFIG = "/icpdas/gprsm/gprsm.ini";

	//rebootTimer
	public static $REBOOTT_DIR = "/icpdas/rebootTimer";
	public static $REBOOTT_EXE = "rebootTimer.php";
	public static $REBOOTT_CONFIG = "/icpdas/rebootTimer/rebootTimer.ini";

	//rebootTimer
	public static $WDTREFRESH_DIR = "/icpdas/wdtRefresh";
	public static $WDTREFRESH_EXE = "wdtRefresh.php";

	//RTU Client
	public static $RTUC_DIR = "/icpdas/rtuc";
	public static $RTUC_EXE = "rtuc.py";
	public static $RTUC_CONFIG = "/icpdas/rtuc/rtuc.ini";

	//NTP Client
	public static $NTPC_DIR = "/icpdas/ntpc";
	public static $NTPC_EXE = "ntpc.php";
	public static $NTPC_CONFIG = "/icpdas/ntpc/ntpc.ini";

	//VPN Client
	public static $VPNC_DIR = "/icpdas/vpnc";
	public static $VPNC_EXE = "vpnc.php";
}

//== get or set interface information from "/etc/network/interfaces"
class Network
{
	public $NetName="eth0";
	public $mode;
	public $address;
	public $netmask;
	public $gateway;
	public $broadcast;
	public $network;

	function Network($Interfaces="eth0")
	{
		$this->NetName=$Interfaces;
		//$this->getNetConfig();
	}

	//-- get Net Interface information
	function getNetConfig()
	{
		$info = file_get_contents(CommonData::$NETWORK_SETTING_PATH);
		$info_array = explode("\n", $info);
		$IsObject = false;
		$this->mode = "DHCP";
		foreach($info_array as $index => $line)
		{
			$line = trim($line);
			//if($line[0] == '#') continue;
			if(!$IsObject)
			{
				if(strstr($line,"iface ".$this->NetName) === false)
					continue;
				else
					$IsObject=true;
			}
			if($IsObject && $line == "")//if get a empty line--> out object zone
			{
				break;
			}

			//into settings block
			//#iface eth0 inet static
			if(strpos($line, "iface eth0 inet static") !== false)
				$this->mode = "Static";

			if(($pos=strpos($line, "address")) !== false)
				$this->address = trim(substr($line, $pos+7));
			else if(($pos=strpos($line, "netmask")) !== false)
				$this->netmask = trim(substr($line, $pos+7));
			else if(($pos=strpos($line, "gateway")) !== false)
				$this->gateway = trim(substr($line, $pos+7));
			else if(($pos=strpos($line, "broadcast")) !== false)
				$this->broadcast = trim(substr($line, $pos+9));
			else if(($pos=strpos($line, "network")) !== false)
				$this->network = trim(substr($line, $pos+7));
		}
	}

	//-- set Net Interface information
	//	must have a empty line between 2 interfaces (configure ending flag)
	function setNetConfig()
	{
		$data = "auto lo\n". "iface lo inet loopback\n\n";
		$data = $data ."allow-hotplug eth0\n";
		if($this->mode == "DHCP")
		{
			$data = $data ."iface eth0 inet dhcp\n";
			$data = $data ."#" ."address " .$this->address ."\n";
			$data = $data ."#" ."netmask " .$this->netmask ."\n";
			$data = $data ."#" ."gateway " .$this->gateway ."\n";
			$data = $data ."#" ."broadcast 192.168.255.255" ."\n";//$this->broadcast
			$data = $data ."#" ."network 192.168.0.0" ."\n";		//$this->network
		}else
		{
			$data = $data ."iface eth0 inet static\n";
			$data = $data ."address " .$this->address ."\n";
			$data = $data ."netmask " .$this->netmask ."\n";
			if($this->gateway=="")
				$data = $data ."#" ."gateway " .$this->gateway ."\n";
			else
				$data = $data ."gateway " .$this->gateway ."\n";
			$data = $data ."#" ."broadcast 192.168.255.255" ."\n";//$this->broadcast
			$data = $data ."#" ."network 192.168.0.0" ."\n";		//$this->network
		}

		file_put_contents(CommonData::$NETWORK_SETTING_PATH, $data);
		return true;
	}

}

//== read DNS IP from the configuration file
function getDNS(&$DNS)
{
	$info = file_get_contents(CommonData::$DNS_SETTING_PATH);
	$info_array = explode("\n", $info);
	$dns_num =  0;

	foreach($info_array as $index => $line)
	{
		$line = trim($line);
		if($line[0] == '#') continue;

		if($pos = strpos($line, "nameserver") !== false)
		{
			$DNS[$dns_num] = trim(substr($line, $pos+10));
			$dns_num++;
			if($dns_num>=2) break;
		}
	}
}

//== write DNS IP to the configuration file
function setDNS(&$DNS)
{
	$dns_num =  0;	//DNS can set up to 2 IP

	for($i=0; $i<count($DNS); $i++)
	{
		if($DNS[$i] != "")
		{
			$array_data[$dns_num] = "nameserver ".$DNS[$i];
			$dns_num++;
		}
		if($dns_num>=2) break;
	}

	$data = implode("\n", $array_data)."\n";
	file_put_contents(CommonData::$DNS_SETTING_PATH,$data);
}


//== get PIN code from Modem configure file
function getPINCode(&$cpin)
{
	$IsObject=false;
	$data=file_get_contents(CommonData::$MODEM_INIT_SETTING_FILE);
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);

		if($line[0]=='#') continue;

		list($name , $value)=split('=' , $line);
		if($name == "pincode"){
			if( strlen($value) > 4 )	$value=substr($value, 0, 4);
			$cpin = $value;
		}
	}
}

//== set PIN code from Modem configure file
function setPINCode($cpin)
{
	$data=file_get_contents(CommonData::$MODEM_INIT_SETTING_FILE);
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);

		list($name , $value)=split('=' , $line);
		if($name == "pincode"){
			$line = "pincode=" .$cpin;
			$array_data[$index]=$line;
			break;
		}
	}

	$data=implode("\n",$array_data);
	file_put_contents(CommonData::$MODEM_INIT_SETTING_FILE,$data);
}

//== get pppd configure
function getpppdCfg(&$phone, &$apn, &$uname, &$upwd)
{
	//get APN and phone number
	$data=file_get_contents(CommonData::$PPPD_CHATSCRIPTS);
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);

		if($line[0]=='#') continue;

		if(strpos($line, "AT+CGDCONT") !== false){

			if(($pos=strrpos($line, ",")) !== false){

				$apn = trim(substr($line, $pos+2, strlen($line)-($pos+2)-1));
			}

		}else if(($pos=strpos($line, "ATD")) !== false){

			$phone =substr($line, $pos+3, strlen($line)-($pos+3));

		}
	}

	//get user name in ./peers/3g (pppd use it)
	$data=file_get_contents(CommonData::$PPPD_PEERS);
	$array_data=explode("\n",$data);
	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);
		if($line[0]=='#') continue;

		if(($pos=strpos($line, "user")) !== false)
		{
			$uname = trim(substr($line, $pos+4));
			$uname = trim($uname, "\"");
			break;
		}
	}

	//get password in "/etc/ppp/pap-secrets"
	$data=file_get_contents(CommonData::$PPPD_PAP_SECRETS);
	$array_data=explode("\n",$data);
	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);
		if($line[0]=='#') continue;

		if(strpos($line, ("\"".$uname."\"")) !== false)
		{
			$items = explode("\t", $line);
			$upwd = trim(trim($items[2]), "\"");
			break;
		}
	}
}

//== set pppd configure
function setpppdCfg($phone, $apn, $uname, $upwd)
{
	//- set APN and phone number
	$data=file_get_contents(CommonData::$PPPD_CHATSCRIPTS);
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);
		if($line[0]=='#') continue;

		if(strpos($line, "AT+CGDCONT") !== false){

			if(($pos=strrpos($line, ",")) !== false)
			{
				$line = substr($line, 0, $pos+1) ."\"" .$apn ."\"";
				$array_data[$index] = $line;
			}

		}else if(($pos=strpos($line, "ATD")) !== false)
		{
			$line = substr($line, 0, $pos+3) .$phone;
			$array_data[$index] = $line;
		}
	}
	$data=implode("\n",$array_data);
	file_put_contents(CommonData::$PPPD_CHATSCRIPTS,$data);


	//- set user name in ./peers/3g (pppd use it)
	$data=file_get_contents(CommonData::$PPPD_PEERS);
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);

		if($line[0]=='#') continue;

		//if set as 「user 」, pppd will crash. must be 「user ""」
		if(strpos($line, "user") !== false)
		{
			$line="user \"" .$uname ."\"";
			$array_data[$index] = $line;

			break;
		}
	}
	$data=implode("\n", $array_data);
	file_put_contents(CommonData::$PPPD_PEERS, $data);


	//set user name and password
	//Using PAP (Password Authentication Protocol)
	$data=file_get_contents(CommonData::$PPPD_PAP_SECRETS);
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);
		if($line[0]=='#') continue;

		$line="\"" .$uname ."\"\t" ."*" ."\t\"" .$upwd ."\"";
		$array_data[$index] = $line;

		break;
	}
	$data=implode("\n", $array_data);
	file_put_contents(CommonData::$PPPD_PAP_SECRETS, $data);

	//Using CHAP
	$data=file_get_contents(CommonData::$PPPD_CHAP_SECRETS);
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);
		if($line[0]=='#') continue;

		$line="\"" .$uname ."\"\t" ."*" ."\t\"" .$upwd ."\"";
		$array_data[$index] = $line;

		break;
	}
	$data=implode("\n", $array_data);
	file_put_contents(CommonData::$PPPD_CHAP_SECRETS, $data);
}

//== set pppd udev rule
function getpppdRule(&$enable)
{
	$data=file_get_contents(CommonData::$PPPD_UDEV_FILE);
	if($data[0]=="#")
		$enable="disable";
	else
		$enable="enable";
}

//== set pppd udev rule
function setpppdRule($enable)
{
	$data=file_get_contents(CommonData::$PPPD_UDEV_FILE);
	if($enable=="enable")
	{
		if($data[0]=="#")
			$data = substr($data, 1);
	}else
	{
		if($data[0]!="#")
			$data = "#" .$data;
	}
	//print_r($data);

	file_put_contents(CommonData::$PPPD_UDEV_FILE, $data);
}


//== gety Net Information
function getNetInfo(&$net_info)
{
	try
	{
		//-- check eth0 is dhcp or static IP
		$info = file_get_contents(CommonData::$NETWORK_SETTING_PATH);
		$info_array = explode("\n", $info);
		$IsObject = false;
		foreach($info_array as $index => $line)
		{
			$line = trim($line);
			if($line[0] == '#') continue;
			if(strstr($line,"iface eth0") !== false)
				break;
		}
		if(strpos($line, "dhcp") !== false)
			$net_info["eth0_mode"] = "DHCP";
		else
			$net_info["eth0_mode"] = "static";

		//-- eth0 --
		$cmd = "ifconfig eth0";
		$info = shell_exec($cmd);
		//-- get Mac
		$info = strstr($info, "HWaddr");
		strtok($info, "\r\n ");
		$net_info["eth0_mac"] = strtok("\r\n ");

		//-- get IP
		$info = strstr($info, "inet addr:");
		strtok($info, ":");
		$net_info["eth0_ip"] = strtok("\t ");

		//-- get Mask
		$info = strstr($info, "Mask:");
		strtok($info, ":");
		$net_info["eth0_mask"] = strtok("\n ");


		//-- ppp0 --
		$cmd = "ifconfig ppp0";
		$info = shell_exec($cmd);
		//-- get IP
		$info = strstr($info, "inet addr:");
		strtok($info, ":");
		$net_info["ppp0_ip"] = strtok("\t ");

		//-- get connect status
		if($net_info["ppp0_ip"] == "")
			$net_info["ppp0_conn"] = "not connect";
		else
			$net_info["ppp0_conn"] = "connected";

		//-- get P-t-P (broad cast)
		$info = strstr($info, "P-t-P:");
		strtok($info, ":");
		$net_info["ppp0_ptp"] = strtok("\t ");

		//-- get Mask
		$info = strstr($info, "Mask:");
		strtok($info, ":");
		$net_info["ppp0_mask"] = strtok("\n ");

		//-- ppp1 --
		$cmd = "ifconfig ppp1";
		$info = shell_exec($cmd);
		//-- get IP
		$info = strstr($info, "inet addr:");
		strtok($info, ":");
		$net_info["ppp1_ip"] = strtok("\t ");

		//-- get connect status
		if($net_info["ppp1_ip"] == "")
			$net_info["ppp1_conn"] = "not connect";
		else
			$net_info["ppp1_conn"] = "connected";

		//-- get P-t-P (broad cast)
		$info = strstr($info, "P-t-P:");
		strtok($info, ":");
		$net_info["ppp1_ptp"] = strtok("\t ");

		//-- get Mask
		$info = strstr($info, "Mask:");
		strtok($info, ":");
		$net_info["ppp1_mask"] = strtok("\n ");
	}
	catch (Exception $e)
	{
	}
}

//== get Modem state (CPIN, CREG, CSQ)
function getModemSta(&$modem_sta)
{
	try
	{
		$info = shell_exec("ps|grep configModem.sh");
		if(strstr($info, "/icpdas/bin/configModem.sh")) return;

		//-- Modem Status, 依序為：cpintype, cregvalue, csqvalue
		if(file_exists("/icpdas/modemInfo.txt"))
			$info = file_get_contents("/icpdas/modemInfo.txt");
		else
			$info = "";

		//-- get CPIN
		$info = strstr($info, "cpintype");
		$tmp = strtok($info, "=");
		$modem_sta["modem_cpin"] = strtok("\r\n");

		//-- get CREG
		$info = strstr($info, "cregvalue");
		strtok($info, "=");
		$modem_sta["modem_creg"] = strtok("\r\n");

		//-- get CSQ(signal)
		$info = strstr($info, "csqvalue");
		strtok($info, "=");
		$modem_sta["modem_csq"] = strtok("\r\n");
	}
	catch (Exception $e)
	{
	}
}


//=====================================
//==== system information function ====
//=====================================

//== get system information
function getSysInfo(&$sysInfo)
{
	//- get device name
	//$sysInfo["name"] = "GL-5000";
	$info = file_get_contents(CommonData::$CMDLINE_FILE);
	$info = strstr($info, "productname");
	strtok($info, "=");
	$sysInfo["name"] = strtok(" \r\n");

	//- get Serial Number
	$cmd = CommonData::$INFOR_SN;
	$info = shell_exec($cmd);
	$line = explode("\n", $info, 2);
	$sysInfo["sn"] = $line[0];

	//- get OS release version
	$cmd = CommonData::$OS_KERNEL_VER;
	$info = shell_exec($cmd);
	$sysInfo["os_kernel_ver"] = trim($info);

	//- get OS version : ICPDAS Kernel Version: 1.0.0 2012/08/20
	$info = file_get_contents(CommonData::$OS_VER_FILE);
	$info = strstr($info, ":");
	$sysInfo["os_ver"] = trim($info, ": ");

}

//== get storage information
function getStorage(&$sysStorage)
{
	//- check USB storage
	$cmd = "ls /sys/block |grep \"sda\"";
	$info = shell_exec($cmd);
	$info = trim($info);
	if($info != "")
	{
		//check can be remove?
//		$sysStorage["usb_removable"] = trim(file_get_contents("/sys/block/sda/removable"));

		$size_str = trim(file_get_contents("/sys/block/sda/size"));//unit = 512byte(1 sector)
		$sysStorage["usb_size"] = intval($size_str)/2048;//MB
	}

	// get mount information
	$cmd = "mount";
	$info = shell_exec($cmd);
	$info_array = explode("\n", $info);
	foreach($info_array as $index=>$line)
	{
		$line = trim($line);
		if(strncmp($line, "/dev/sda1", 9) == 0)	//if find "sda1"
		{
			$sysStorage["usb_ismount"] = "true";
			$value_array = explode(" ", $line);
			$sysStorage["usb_path"] = $value_array[2];
			$sysStorage["usb_name"] = $value_array[0];
			break;
		}else
		{
			$sysStorage["usb_ismount"] = "false";
		}
	}
}

//== get disk Infomation
function getDiskInfo(&$diskInfo)
{
	$cmd = "busybox df";
	$info = shell_exec($cmd);
	$info_array = explode("\n", $info);
	foreach($info_array as $i=>$line)
	{
		$line = trim($line);
		if($line == "") continue;

		sscanf($line, "%s %s %s %s %s %s", $diskInfo[$i]["name"], $diskInfo[$i]["size"],
			$diskInfo[$i]["used"], $diskInfo[$i]["available"], $diskInfo[$i]["per"],
			$diskInfo[$i]["path"]);
	}
}

//================================
//==== Routing Table Function ====
//================================

//== get NAT POSTROUTING Configure
//parameter:
//		$routing[index]["source"]	source IP
//		$routing[index]["mask"]		1~31
//		$routing[index]["output"]	output interface
function getRoutingCfg(&$routing)
{
	$routing_keyword = "iptables -t nat -A POSTROUTING -s";
	$ROUTING_start = "#-NAT: ROUTING start-";
	$ROUTING_end = "#-NAT: ROUTING end-";

	$info = file_get_contents(CommonData::$NAT_PATH);
	$info_array = explode("\n", $info);

	$IsObject = false;
	$j = 0;
	foreach($info_array as $index => $line)
	{
		$line = trim($line);
		if(!$IsObject)
		{
			if(strstr($line, $ROUTING_start) !== false)
				$IsObject=true;
			else
				continue;
		}

		if($IsObject && strstr($line, $ROUTING_end) !== false)//out of routing config
			break;

		//into settings block
		if(strpos($line, $routing_keyword) !== false)
		{
			$line = strstr($line, "-s");
			strtok($line, " ");
			$routing[$j]["source"] = strtok("/");
			$routing[$j]["mask"] = strtok(" ");

			$line = strstr($line, "-o");
			strtok($line, " ");
			$routing[$j]["output"] = strtok(" ");

			$j++;
		}
	}
}

//== set NAT POSTROUTING Configure
//parameter:
//		$routing[index]["source"]	source IP
//		$routing[index]["mask"]		0~32 (24~32 in web)
//		$routing[index]["output"]	output interface
function setRoutingCfg($routing)
{
	$routing_keyword = "iptables -t nat -A POSTROUTING -s";
	$ROUTING_start = "#-NAT: ROUTING start-";
	$ROUTING_end = "#-NAT: ROUTING end-";

	$info = file_get_contents(CommonData::$NAT_PATH);
	$pos1 = strpos($info, $ROUTING_start);
	$pos2 = strpos($info, $ROUTING_end, $pos1);
	//echo "pos1=$pos1, pos2=$pos2, pos3=$pos3\n";
	$str1 = substr($info, 0, $pos1).$ROUTING_start ."\n";
	$str2 = "\t".substr($info, $pos2);
	foreach($routing as $i=>$item)
	{
		$config = $config."\tiptables -t nat -A POSTROUTING -s ".$item["source"].
			"/".$item["mask"]." -o ".$item["output"]." -j MASQUERADE\n";
	}
	$newRule = $str1.$config.$str2;
	//echo $newRule;
	file_put_contents(CommonData::$NAT_PATH, $newRule);
}

//== get DNAT Port Mapping Configure
//parameter:
//	$mapping[0]["type"]		package type (tcp, udp, icmp, all)
//	$mapping[0]["from"]		from interface (ppp0)
//	$mapping[0]["port"]		from port
//	$mapping[0]["to_ip"]	to address
//	$mapping[0]["to_port"]	to port
function getPortMappingCfg(&$mapping)
{
	$routing_keyword = "iptables -t nat -I PREROUTING -p";
	$MAPPING_start = "#-NAT: MAPPING start-";
	$MAPPING_end = "#-NAT: MAPPING end-";

	$info = file_get_contents(CommonData::$NAT_PATH);
	$info_array = explode("\n", $info);

	$IsObject = false;
	$j = 0;
	foreach($info_array as $index => $line)
	{
		$line = trim($line);
		if(!$IsObject)
		{
			if(strstr($line, $MAPPING_start) !== false)
				$IsObject=true;
			else
				continue;
		}

		if($IsObject && strstr($line, $MAPPING_end) !== false)//out of routing config
			break;

		//into settings block
		if($line[0] == '#') continue;
		if(strpos($line, $routing_keyword) !== false)
		{
			$line = strstr($line, "-p");
			strtok($line, " ");
			$mapping[$j]["type"] = strtok(" ");	//tcp, udp, icmp, all
			$line = strstr($line, "-i");
			strtok($line, " ");
			$mapping[$j]["from"] = strtok(" ");//interface
			$line = strstr($line, "--dport");
			strtok($line, " ");
			$mapping[$j]["port"] = strtok(" ");
			$line = strstr($line, "--to-destination");
			strtok($line, " ");
			$mapping[$j]["to_ip"] = strtok(":");
			$mapping[$j]["to_port"] = strtok("\n");

			$j++;
		}
	}
}

//== set DNAT Port Mapping Configure
//parameter:
//	$mapping[0]["type"]		package type (tcp, udp, icmp, all)
//	$mapping[0]["from"]		from interface (ppp0)
//	$mapping[0]["port"]		from port
//	$mapping[0]["to_ip"]	to address
//	$mapping[0]["to_port"]	to port
function setPortMappingCfg($mapping)
{
	$routing_keyword = "iptables -t nat -A POSTROUTING -s";
	$MAPPING_start = "#-NAT: MAPPING start-";
	$MAPPING_end = "#-NAT: MAPPING end-";

	$info = file_get_contents(CommonData::$NAT_PATH);
	$pos1 = strpos($info, $MAPPING_start);
	$pos2 = strpos($info, $MAPPING_end, $pos1);

	$str1 = substr($info, 0, $pos1).$MAPPING_start."\n";
	$str2 = "\t".substr($info, $pos2);
	foreach($mapping as $i=>$item)
	{
		$config = $config."\tiptables -t nat -I PREROUTING -p ".$item["type"].
			" -i ".$item["from"]." --dport ".$item["port"]." -j DNAT --to-destination ".
			$item["to_ip"].":".$item["to_port"]."\n";
	}
	$newRule = $str1.$config.$str2;
	//echo $newRule;
	file_put_contents(CommonData::$NAT_PATH, $newRule);
}

function isIP($ip)
{
	$items = explode(".", $ip);
	foreach($items as $value)
	{
		if($value>255)
			return false;
	}

	return (ereg("^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})$", $ip));
}

//check password format
function isPW($pw)
{
	return (ereg("([0-9]|[a-z]|[A-Z]){4,20}", $pw));
}

function systemReboot()
{
	shell_exec("reboot");
}


//==================================
//==== process manager function ====
//==================================

//== get system process configure
//	sys_proc:
//		[process_name]	[start command]	[stop command]	[execute file]
function getSysProcCgf(&$sys_proc)
{
	// check is file exist?
	if(!file_exists(CommonData::$SYSPROC_FILE))
		shell_exec("touch " .CommonData::$SYSPROC_FILE);

	$info = file_get_contents(CommonData::$SYSPROC_FILE);
	$info_array = explode("\n", $info);

	$IsObject = false;
	$j = 0;
	foreach($info_array as $index => $line)
	{
		$line = trim($line);
		if($line[0] == '#') continue;

		$items = explode("\t", $line);
		if(count($items)<4) continue;

		$sys_proc[$j]["name"] = $items[0];
		$sys_proc[$j]["start"] = $items[1];
		$sys_proc[$j]["stop"] = $items[2];
		$sys_proc[$j]["exec"] = $items[3];

		$j++;
	}
	$ps_list = shell_exec("ps");

	if($j>0)
	{
		foreach($sys_proc as $index => $list)
		{
			if(strpos($ps_list, $list["exec"]) !== false)
				$sys_proc[$index]["running"] = "true";
			else
				$sys_proc[$index]["running"] = "false";
		}
	}
}

//== remove a process from configure
function removeSysProc($sys_proc_name)
{
	$info = file_get_contents(CommonData::$SYSPROC_FILE);
	$info_array = explode("\n", $info);

	$j = 0;
	foreach($info_array as $index => $line)
	{
		$line = trim($line);
		if($line[0] == '#') continue;

		$items = explode("\t", $line);

		if($items[0] == $sys_proc_name)
			$info_array[$index] = "";
	}

	foreach($info_array as $index => $line)
	{
		if($line != "")
			$new_info = $new_info .$line ."\n";
	}
	file_put_contents(CommonData::$SYSPROC_FILE, $new_info);
}

//== add a system process
//		name:	process name
//		start:	start command
//		stop:	stop command
//		exec:	process execute file
function addSysProc($name, $start, $stop, $exec)
{
	$info = file_get_contents(CommonData::$SYSPROC_FILE);
	$info_array = explode("\n", $info);

	$IsObject = false;
	$n = count($info_array);
	for($i=0; $i<$n; $i++)
	{
		$line = trim($info_array[$i]);
		if($line[0] == '#') continue;

		$items = explode("\t", $line);

		if($items[0] == $name)
		{
			$info_array[$i] = $name ."\t" .$start ."\t" .$stop ."\t" .$exec;
			break;
		}
	}
	//if can't find process Name in file, add it
	if($i == $n)
		$info_array[$n] = $name ."\t" .$start ."\t" .$stop ."\t" .$exec;

	foreach($info_array as $index => $line)
	{
		if($line != "")
			$new_info = $new_info .$line ."\n";
	}
	file_put_contents(CommonData::$SYSPROC_FILE, $new_info);
}

//== get User process configure
//	proc_list:
//		[process_name]	[start command]	[stop command]	[execute file]	[auto run]
function getUserProcCgf(&$proc_list)
{
	if(!file_exists(CommonData::$USERPROC_FILE))
		shell_exec("touch " .CommonData::$USERPROC_FILE);

	$info = file_get_contents(CommonData::$USERPROC_FILE);
	$info_array = explode("\n", $info);

	$IsObject = false;
	$j = 0;
	$proc_list = NULL;
	foreach($info_array as $index => $line)
	{
		$line = trim($line);
		if($line[0] == '#') continue;

		$items = explode("\t", $line);
		if(count($items)<5) continue;

		$proc_list[$j]["name"] = $items[0];
		$proc_list[$j]["start"] = $items[1];
		$proc_list[$j]["stop"] = $items[2];
		$proc_list[$j]["exec"] = $items[3];
		$proc_list[$j]["autorun"] = $items[4];

		$j++;
	}
	$ps_list = shell_exec("ps");

	if($j>0)
	{
		foreach($proc_list as $index => $list)
		{
			if(strpos($ps_list, $list["exec"]) !== false)
				$proc_list[$index]["running"] = "true";
			else
				$proc_list[$index]["running"] = "false";
		}
	}
}

//== remove a process from configure
function removeUserProc($proc_name)
{
	$info = file_get_contents(CommonData::$USERPROC_FILE);
	$info_array = explode("\n", $info);

	$j = 0;
	foreach($info_array as $index => $line)
	{
		$line = trim($line);
		if($line[0] == '#') continue;

		$items = explode("\t", $line);

		if($items[0] == $proc_name)
			$info_array[$index] = "";
	}

	foreach($info_array as $index => $line)
	{
		if($line != "")
			$new_info = $new_info .$line ."\n";
	}
	file_put_contents(CommonData::$USERPROC_FILE, $new_info);
}

//== add a User process
//		name:	process name
//		start:	start command
//		stop:	stop command
//		exec:	process execute file
//		autorun:	auto-run process after booting
function addUserProc($name, $start, $stop, $exec, $autorun)
{
	$info = file_get_contents(CommonData::$USERPROC_FILE);
	$info_array = explode("\n", $info);

	$IsObject = false;
	$n = count($info_array);
	for($i=0; $i<$n; $i++)
	{
		$line = trim($info_array[$i]);
		if($line[0] == '#') continue;

		$items = explode("\t", $line);

		if($items[0] == $name)
		{
			$info_array[$i] = $name ."\t" .$start ."\t" .$stop ."\t" .$exec ."\t" .$autorun;
			break;
		}
	}
	//if can't find process Name in file, add it
	if($i == $n)
		$info_array[$n] = $name ."\t" .$start ."\t" .$stop ."\t" .$exec ."\t" .$autorun;

	foreach($info_array as $index => $line)
	{
		if($line != "")
			$new_info = $new_info .$line ."\n";
	}
	file_put_contents(CommonData::$USERPROC_FILE, $new_info);
}


//== set autorun User process configure
//	auto-run proc_list:
//		[start command]
function setAutoRunFW(&$proc_list)
{
	if(!file_exists(CommonData::$AUTORUN_FILE))
	{
		shell_exec("touch " .CommonData::$AUTORUN_FILE);
		shell_exec("chmod +x " .CommonData::$AUTORUN_FILE);
	}

	$info = "";
	$n = count($proc_list);
	for($i=0; $i<$n; $i++)
	{
		if($proc_list[$i]["autorun"] == "enable")
			$info = $info .$proc_list[$i]["start"] ." &\n";
	}
	file_put_contents(CommonData::$AUTORUN_FILE, $info);
}


//=====================
//==== vxsc manage ====
//=====================
//== get system information
function getVxscInfo(&$serverIP, &$serverPort, &$heartbeatTime, &$virtualIP, &$moduleAlias, &$TimeInterval, &$UartDataMax
	, &$IsTCP2RTU1, &$IsTCP2RTU2, &$Baudrate1, &$Baudrate2, &$Format1, &$Format2, &$enable, &$vxsc_alive, &$vxsc_version)
{
	$IsObject=false;
	$data=file_get_contents(CommonData::$VXSC_CONFIG);
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);

		if($line[0]=='#') continue;

		list($name , $value)=split('=' , $line);
		if($name == "ServerIP"){
			$serverIP = $value;
		}else if($name == "ServerPort")
		{
			$serverPort = $value;
		}else if($name == "HeartbeatTime")
		{
			$heartbeatTime = $value;
		}else if($name == "VirtualIP")
		{
			$virtualIP = $value;
		}
		else if($name == "ModuleAlias")
		{
			$moduleAlias = $value;
		}
		else if($name == "TimeInterval")
		{
			$TimeInterval = $value;
		}
		else if($name == "UartDataMax")
		{
			$UartDataMax = $value;
		}
		else if($name == "IsTCP2RTU1")
		{
			$IsTCP2RTU1 = $value;
		}
		else if($name == "IsTCP2RTU2")
		{
			$IsTCP2RTU2 = $value;
		}
		else if($name == "Baudrate1")
		{
			$Baudrate1 = $value;
		}
		else if($name == "Baudrate2")
		{
			$Baudrate2 = $value;
		}
		else if($name == "Format1")
		{
			$Format1 = $value;
		}
		else if($name == "Format2")
		{
			$Format2 = $value;
		}
	}

	//--check if vxsc.exe is enable
	$proc_name = CommonData::$VXSC_EXE;
	$full_file_name = CommonData::$VXSC_DIR ."/" .$proc_name;
	getUserProcCgf($proc_list);
	$n = count($proc_list);
	for($i=0; $i<$n; $i++)
	{
		if($proc_list[$i]["exec"] == $full_file_name)
		{
			$enable = $proc_list[$i]["autorun"];
			$vxsc_alive = $proc_list[$i]["running"];
			break;
		}
	}

	//- get version
	$vxsc_version = shell_exec($full_file_name ." --ver");
	$array_data = explode("=", $vxsc_version);
	$vxsc_version = trim($array_data[1]);
}

//== set system information
function setVxscInfo($serverIP, $serverPort, $heartbeatTime, $virtualIP, $moduleAlias, $TimeInterval, $UartDataMax
	, $IsTCP2RTU1, $IsTCP2RTU2, $Baudrate1, $Baudrate2, $Format1, $Format2)
{
	$data="";
	$data = $data ."ServerIP=" .$serverIP ."\n";
	$data = $data ."ServerPort=" .$serverPort ."\n";
	$data = $data ."HeartbeatTime=" .$heartbeatTime ."\n";
	$data = $data ."VirtualIP=" .$virtualIP ."\n";
	$data = $data ."ModuleAlias=" .$moduleAlias ."\n";
	$data = $data ."TimeInterval=" .$TimeInterval ."\n";
	$data = $data ."UartDataMax=" .$UartDataMax ."\n";
	$data = $data ."IsTCP2RTU1=" .$IsTCP2RTU1 ."\n";
	$data = $data ."IsTCP2RTU2=" .$IsTCP2RTU2 ."\n";
	$data = $data ."Baudrate1=" .$Baudrate1 ."\n";
	$data = $data ."Baudrate2=" .$Baudrate2 ."\n";
	$data = $data ."Format1=" .$Format1 ."\n";
	$data = $data ."Format2=" .$Format2 ."\n";
	file_put_contents(CommonData::$VXSC_CONFIG, $data);
}

//============================
//==== gprsMonitor manage ====
//============================
//== get information
function getGprsMonitorInfo(&$serverIP, &$maxRetry, &$interval, &$timeout, &$enable, &$alive, &$version)
{
	$IsObject=false;
	$data=file_get_contents(CommonData::$GPRSM_CONFIG);
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);

		if($line[0]=='#') continue;

		list($name , $value)=split('=' , $line);
		if($name == "serverIP"){
			$serverIP = $value;
		}else if($name == "maxRetry")
		{
			$maxRetry = (int)$value;
		}else if($name == "interval")
		{
			$interval = (int)$value;
		}else if($name == "timeout")
		{
			$timeout = $value;
		}
	}

	//--check if vxsc.exe is enable
	$proc_name = CommonData::$GPRSM_EXE;
	$full_file_name = CommonData::$GPRSM_DIR ."/" .$proc_name;
	getUserProcCgf($proc_list);
	$n = count($proc_list);
	for($i=0; $i<$n; $i++)
	{
		if($proc_list[$i]["exec"] == $full_file_name)
		{
			$enable = $proc_list[$i]["autorun"];
			$alive = $proc_list[$i]["running"];
			break;
		}
	}

	//- get version
	$version = shell_exec($full_file_name ." --ver");
	$array_data = explode("=", $version);
	$version = trim($array_data[1]);
}

//== set config
function setGprsMonitorInfo($serverIP, $maxRetry, $interval, $timeout)
{
	$data="";
	$data = $data ."serverIP=" .$serverIP ."\n";
	$data = $data ."maxRetry=" .$maxRetry ."\n";
	$data = $data ."interval=" .$interval ."\n";
	$data = $data ."timeout=" .$timeout ."\n";
	file_put_contents(CommonData::$GPRSM_CONFIG, $data);
}

//============================
//==== Reboot Timer manage ====
//============================
//== get information
function getRebootTimerInfo(&$rbHour, &$rbMinute, &$enable, &$alive, &$version)
{
	$rbHour = 0;
	$rbMinute = 0;
	$IsObject=false;
	$data=file_get_contents(CommonData::$REBOOTT_CONFIG);
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);

		if($line[0]=='#') continue;

		list($name , $value)=split('=' , $line);
		if($name == "rbHour")
		{
			$rbHour = (int)$value;
		}
		if($name == "rbMinute")
		{
			$rbMinute = (int)$value;
		}
	}

	//--check if rebootTimer.exe is enable
	$proc_name = CommonData::$REBOOTT_EXE;
	$full_file_name = CommonData::$REBOOTT_DIR ."/" .$proc_name;
	getUserProcCgf($proc_list);
	$n = count($proc_list);
	for($i=0; $i<$n; $i++)
	{
		if($proc_list[$i]["exec"] == $full_file_name)
		{
			$enable = $proc_list[$i]["autorun"];
			$alive = $proc_list[$i]["running"];
			break;
		}
	}

	//- get version
	$version = shell_exec($full_file_name ." --ver");
	$array_data = explode("=", $version);
	$version = trim($array_data[1]);
}

//== set config
function setRebootTimerInfo($rbHour, $rbMinute)
{
	$data="";
	$data = $data ."rbHour=" .$rbHour ."\n";
	$data = $data ."rbMinute=" .$rbMinute ."\n";
	file_put_contents(CommonData::$REBOOTT_CONFIG, $data);
}

//============================
//==== WDT Refresh manage ====
//============================
//== get information
function getWdtRefreshInfo(&$enable, &$alive, &$version)
{
	//--check if rebootTimer.exe is enable
	$proc_name = CommonData::$WDTREFRESH_EXE;
	$full_file_name = CommonData::$WDTREFRESH_DIR ."/" .$proc_name;
	getUserProcCgf($proc_list);
	$n = count($proc_list);
	for($i=0; $i<$n; $i++)
	{
		if($proc_list[$i]["exec"] == $full_file_name)
		{
			$enable = $proc_list[$i]["autorun"];
			$alive = $proc_list[$i]["running"];
			break;
		}
	}
	//- get version
	$version = shell_exec($full_file_name ." --ver");
	$array_data = explode("=", $version);
	$version = trim($array_data[1]);
}

//== set wdt process ON/OFF
function wdtOnOff($enable)
{
	//-- auto-run manage
	if($enable=="enable")
		$enable="enable";
	else
		$enable="disable";

	$proc_name = CommonData::$WDTREFRESH_EXE;
	$full_file_name = CommonData::$WDTREFRESH_DIR ."/" .$proc_name;
	//- php call php-script時，需要把「輸入/輸出」重導到別的地方，不可用std io，否則不會執行成功
	addUserProc("WDT Refresh", $full_file_name ." > /dev/null", CommonData::$WDTREFRESH_DIR ."/kill_wdtRefresh.sh", $full_file_name, $enable);
	getUserProcCgf($proc_list);
	setAutoRunFW($proc_list);

	//-- Start/Stop firmware
	$n = count($proc_list);
	for($i=0; $i<$n; $i++)
	{
		if($proc_list[$i]["exec"] == $full_file_name)
		{
			//enable--> restart FW
			if($enable=="enable")
			{
				shell_exec($proc_list[$i]["stop"]);
				pclose(popen($proc_list[$i]["start"] ." &", "r"));//put into backgroud, or php will be block
				break;
			}else
			{
				shell_exec($proc_list[$i]["stop"]);
				break;
			}
		}
	}
}

//==========================
//==== NTP / Time Setting
//==========================

//== get system information
function getNtpcInfo(&$serverIP, &$retryInterval, &$timezone, &$enable, &$alive, &$version)
{
	$IsObject=false;
	$retryInterval = 3600;//default value
	$data=file_get_contents(CommonData::$NTPC_CONFIG);
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);

		if($line[0]=='#') continue;

		list($name , $value)=split('=' , $line);
		if($name == "serverIP"){
			$serverIP = $value;
		}else if($name == "interval")
		{
			$retryInterval = (int)$value;
		}else if($name == "timezone")
		{
			$timezone = $value;
		}
	}

	//--check if vxsc.exe is enable
	$proc_name = CommonData::$NTPC_EXE;
	$full_file_name = CommonData::$NTPC_DIR ."/" .$proc_name;
	getUserProcCgf($proc_list);
	$n = count($proc_list);
	for($i=0; $i<$n; $i++)
	{
		if($proc_list[$i]["exec"] == $full_file_name)
		{
			$enable = $proc_list[$i]["autorun"];
			$alive = $proc_list[$i]["running"];
			break;
		}
	}

	//- get version
	$version = shell_exec($full_file_name ." --ver");
	$array_data = explode("=", $version);
	$version = trim($array_data[1]);
}

//== set system information
function setNtpcInfo($serverIP, $retryInterval, $timezone)
{
	$data="";
	$data = $data ."serverIP=" .$serverIP ."\n";
	$data = $data ."interval=" .$retryInterval ."\n";
	$data = $data ."timezone=" .$timezone ."\n";
	file_put_contents(CommonData::$NTPC_CONFIG, $data);
}


//==========================
//==== password manager ====
//==========================

//== set password
function setPassword($username, $password)
{
	// check is file exist?
	if(!file_exists(CommonData::$HTTPD_PASSWORD_FILE))
		return false;

	$info = file_get_contents(CommonData::$HTTPD_PASSWORD_FILE);
	$info_array = explode("\n", $info);

	$n = count($info_array);
	for($i=0; $i<$n; $i++)
	{
		$line = trim($info_array[$i]);
		if($line[0] == '#') continue;

		$items = explode(":", $line);

		if($items[0] == $username)
		{
			$info_array[$i] = $username .":" .$password;
			break;
		}
	}

	$data = implode("\n", $info_array);
	file_put_contents(CommonData::$HTTPD_PASSWORD_FILE, $data);
	return true;
}


//============================================
//==== web configure file import & export ====
//============================================

//== package the configures
function tarWebConfig()
{
	$full_file_name = CommonData::$PARA_DIR ."/" .CommonData::$PARA_FILE;
	$cmd = "tar -cvf " .$full_file_name ." ";
	$exportFiles =	"/etc/network/interfaces "
					."/etc/resolv.conf "
					."/etc/init.d/S* "
					."/etc/init.d/K* "
					."/etc/ppp/pap-secrets "
					."/etc/ppp/chap-secrets "
					."/etc/ppp/peers/3g "
					."/etc/ppp/chatscripts/3g "
					."/etc/ppp/chatscripts/3g-disconnect "
					."/etc/inadyn.conf "
					."/etc/dhcpd.conf "
					."/etc/php.ini "				//webServer config
					."/etc/php-cgi.ini "			//webServer config
					."/etc/lighttpd.conf "
					//."/etc/.httppasswd "		//網頁不匯出，但在工廠預設值要匯出
					."/etc/udev/rules.d/* "
					."/icpdas/config/* "
					."/icpdas/user_proc/* "
					."/icpdas/vxsc/vxserver.ini "
					."/icpdas/rebootTimer/rebootTimer.ini "
					."/icpdas/rtuc/rtuc.ini "
					."/etc/udev/rules.d/* "
					."/etc/localtime "
;

	$cmd .= $exportFiles;

	$info = shell_exec($cmd);

	//echo "\r\n-- tar webConfig.tar --\r\n";
	//print_r($info);
}

//== un-package the configures
function untarWebConfig()
{
	//- backup S52dhcpd, S46ddns
	shell_exec('mv /etc/init.d/*ddns /tmp/');
	shell_exec('mv /etc/init.d/*dhcpd /tmp/');

	$full_file_name = CommonData::$PARA_DIR ."/" .CommonData::$PARA_FILE;
	$cmd = "tar -xvf " .$full_file_name ." -C /";
	$info = shell_exec($cmd);

	if($info==null)//fail --> restore
	{
		shell_exec('mv /tmp/*ddns /etc/init.d/');
		shell_exec('mv /tmp/*dhcpd /etc/init.d/');
	}

	return $info;
}

//== restore factory setting
function restoreFactory()
{
	//- backup S52dhcpd, S46ddns
	shell_exec('mv /etc/init.d/*ddns /tmp/');
	shell_exec('mv /etc/init.d/*dhcpd /tmp/');

	$full_file_name = CommonData::$FACTORY_FILE;
	$cmd = "tar -xvf " .$full_file_name ." -C /";
	$info = shell_exec($cmd);

	if($info==null)//fail --> restore
	{
		shell_exec('mv /tmp/*ddns /etc/init.d/');
		shell_exec('mv /tmp/*dhcpd /etc/init.d/');
	}

	return $info;
}

?>
