<?php
require_once("../page/class.php");

//true表示array型態，false則是物件
$rtuJson = json_decode(file_get_contents(CommonData::$RTUC_CONFIG),false);

?>
<html>
<head>
<meta content="text/html; charset=UTF-8" http-equiv="content-type">
<title></title>
<script src="js/jquery-1.6.1.js" type="text/javascript"></script>
<style type="text/css">
	.bg_d {
		background-color: #ffcc99;
		color: #000000;
		cursor: pointer;
	}
	.bg_l {
		background-color: #ffe6cc;
		color: #9f9f9f;
	}
</style>
<script type="text/javascript">
	$(function() {
		$(".bg_l").hover(function() {
  			$(this).css("background-color","#ffcc99");
  			$(this).css("color","#000000");
  			$(this).css("cursor","pointer");
  		},function(){
  			$(this).css('background-color','#ffe6cc');
  			$(this).css("color","#9f9f9f");
  			$(this).css("cursor","auto");
  		});

		$("#page1").click(function(){
			window.location.href='fw_rtuc.php';
		});
		$("#page2").click(function(){
			window.location.href='fw_rtuc_mbnumber.php';
		});
		$("#page3").click(function(){
			window.location.href='fw_rtuc_otherpara.php';
		});
	});

	function validateForm() {
        if($("#ftp_port").val()>65535 || $("#ftp_port").val()<1)
        {
            alert('FTP Port = 1~65535');
            $("#ftp_port").focus();
            return;
        }
        if($("#email_mailPort").val()>65535 || $("#email_mailPort").val()<1)
        {
            alert('Email Port = 1~65535');
            $("#email_mailPort").focus();
            return;
        }
        if($("#logTime").val()>86400 || $("#logTime").val()<0)
        {
            alert('Log Interval = 0~86400');
            $("#logTime").focus();
            return;
        }
        if($("#logChangeTime").val()>1440 || $("#logChangeTime").val()<3)
        {
            alert('Log File Interval Time = 3~1440 (minutes)');
            $("#logChangeTime").focus();
            return;
        }

		document.forms["other_para"].submit();
	}
</script>
</head>

<body>
	<br>
	<form id="other_para" name="other_para" method="post" action="fw_rtuc_action.php"><br>
		<table align="center" border="1" cellpadding="2" cellspacing="2" width="600">
			<tbody>
				<tr align="center">
					<td id="page1" class="bg_l">Main Info.</td>
					<td id="page2" class="bg_l">Modbus Device</td>
					<td id="page3" class="bg_d">FTP / Email</td>
				</tr>
			</tbody>
		</table>
		<table align="center" border="1" cellpadding="2" cellspacing="2" width="600">
		<tbody>

        <!-- Data Log parameter -->
		<tr>
			<td bgcolor="#ccffff">Data Log Interval (sec.)</td>
			<td ><input size="20" id="logTime" name="logTime" value="<?php echo $rtuJson->logTime;?>" maxlength=5
						onkeyup="this.value=this.value.replace(/[^0-9]/g,'')"> 0~86400 (0=disable)<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Max. Time per Log File (min.)</td>
			<td ><input size="20" id="logChangeTime" name="logChangeTime" value="<?php echo $rtuJson->logChangeTime/(60);?>" maxlength=2
						onkeyup="this.value=this.value.replace(/[^0-9]/g,'')"> 3~1440 minutes<br>
			</td>
		</tr>


		<!-- log Folder -->
		<tr style="display:none">
			<td bgcolor="#ccffff">Log Dir</td>
			<td ><input size="20" name="log_dir" value="<?php echo $rtuJson->log_dir;?>" ><br>
			</td>
		</tr>

		<tr style="display:none">
			<td bgcolor="#ccffff">Log Ftp Dir</td>
			<td ><input size="20" name="log_ftpDir" value="<?php echo $rtuJson->log_ftpDir;?>" ><br>
			</td>
		</tr>

		<tr style="display:none">
			<td bgcolor="#ccffff">Log Mail Dir</td>
			<td ><input size="20" name="log_mailDir" value="<?php echo $rtuJson->log_mailDir;?>" ><br>
			</td>
		</tr>

		<tr>
			<td colspan="2" bgcolor="#888888">
			</td>
		</tr>

		<!-- FTP parameter -->
		<tr>
			<td bgcolor="#ccffff">FTP Server Address</td>
			<td ><input size="20" id="ftp_serverAddr" name="ftp_serverAddr" value="<?php echo $rtuJson->ftp_serverAddr;?>" >
                empty --> disable FTP<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">FTP Port</td>
			<td ><input size="20" id="ftp_port" name="ftp_port" value="<?php echo $rtuJson->ftp_port;?>" maxlength=5
						onkeyup="this.value=this.value.replace(/[^0-9]/g,'')"> default=21<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">FTP Username</td>
			<td ><input size="20" id="ftp_username" name="ftp_username" value="<?php echo $rtuJson->ftp_username;?>" ><br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">FTP Password</td>
			<td ><input size="20" id="ftp_password" name="ftp_password" value="<?php echo $rtuJson->ftp_password;?>" ><br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Enable FTP Funcion</td>
			<td ><input size="20" name="ftp_enable" type="checkbox" value="enable"<?php if($rtuJson->ftp_enable=="enable") echo "checked";?> >Enable <br>
			</td>
		</tr>

		<tr>
			<td colspan="2" bgcolor="#888888">
			</td>
		</tr>

		<!-- E-mail parameter -->
		<tr>
			<td bgcolor="#ccffff">Email From</td>
			<td ><input size="20" id="email_fromMail" name="email_fromMail" value="<?php echo $rtuJson->email_fromMail;?>" >
                empty --> disable Email<br>
                Ex: abc@gmail.com</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Email To</td>
			<td ><input size="20" id="email_toMails" name="email_toMails" value="<?php echo $rtuJson->email_toMails;?>" >
                Ex: xyz@gmail.com</td>
		</tr>
		<tr>
			<td bgcolor="#ccffff">Example for 2 or more contact</td>
			<td >xx@gmail.com,yy@gmail.com</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Email Server</td>
			<td ><input size="20" id="email_mailServer" name="email_mailServer" value="<?php echo $rtuJson->email_mailServer;?>" >
                Ex: smtp.gmail.com</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Email Server Port</td>
			<td ><input size="20" id="email_mailPort" name="email_mailPort" value="<?php echo $rtuJson->email_mailPort;?>" maxlength=5
						onkeyup="this.value=this.value.replace(/[^0-9]/g,'')"> Ex: 25
                </td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Email Username</td>
			<td ><input size="20" id="email_username" name="email_username" value="<?php echo $rtuJson->email_username;?>" >
                Ex: abc</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Email Password</td>
			<td ><input size="20" id="email_password" name="email_password" value="<?php echo $rtuJson->email_password;?>" >
                Ex: 123abc</td>
		</tr>

		<tr style="display:none">
			<td bgcolor="#ccffff">Max Log File Size</td>
			<td ><input size="20" id="email_max_size" name="email_max_size" value="<?php echo $rtuJson->email_max_size;?>" >
                Byte, 3000000 about 3MB</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Enable Email Funcion</td>
			<td ><input size="20" name="email_enable" type="checkbox" value="enable"<?php if($rtuJson->email_enable=="enable") echo "checked";?> >Enable <br>
			</td>
		</tr>

		<tr align="center">
			<td colspan="2">
				<input name="button" value="Modify" type="button" OnClick="validateForm()">
				<input type="hidden" name="modifyType" value="other">
			</td>
		</tr>

		</tbody>
		</table>
	</form>
</body>
</html>

