<?php
require_once("../page/class.php");

//true表示array型態，false則是物件
$rtuJson = json_decode(file_get_contents(CommonData::$RTUC_CONFIG),false);

//--check do rtu_c.py be enable and running
$proc_name = CommonData::$RTUC_EXE;
$full_file_name = CommonData::$RTUC_DIR ."/" .$proc_name;
getUserProcCgf($proc_list);
$n = count($proc_list);
for($i=0; $i<$n; $i++)
{
    if($proc_list[$i]["exec"] == $full_file_name)
    {
        $enable = $proc_list[$i]["autorun"];
        $alive = $proc_list[$i]["running"];
        break;
    }
}

//--確認rtuc的版本「__version__」
$rtuc_version = "-";
$rtucCode = file_get_contents($full_file_name);
$array_data=explode("\n",$rtucCode, 11);
//var_dump($array_data);
$str_ver = "__version__";
for($i=0; $i<10; $i++)
{
    if(strncmp($array_data[$i], $str_ver, strlen($str_ver))==0)
    {
        list($tmp , $rtuc_version)=split('=' , $array_data[$i]);
        $rtuc_version = trim($rtuc_version, " '");
    }
}

?>
<html>
<head>
<meta content="text/html; charset=UTF-8" http-equiv="content-type">
<title></title>
<script src="js/jquery-1.6.1.js" type="text/javascript"></script>
<style type="text/css">
	.bg_d {
		background-color: #ffcc99;
		color: #000000;
		cursor: pointer;
	}
	.bg_l {
		background-color: #ffe6cc;
		color: #9f9f9f;
	}
</style>
<script type="text/javascript">
	$(function() {
		$(".bg_l").hover(function() {
  			$(this).css("background-color","#ffcc99");
  			$(this).css("color","#000000");
  			$(this).css("cursor","pointer");
  		},function(){
  			$(this).css('background-color','#ffe6cc');
  			$(this).css("color","#9f9f9f");
  			$(this).css("cursor","auto");
  		});

		$("#page1").click(function(){
			window.location.href='fw_rtuc.php';
		});
		$("#page2").click(function(){
			window.location.href='fw_rtuc_mbnumber.php';
		});
		$("#page3").click(function(){
			window.location.href='fw_rtuc_otherpara.php';
		});
	});

	function validateForm() {
        if($("#serverPort").val()>65535 || $("#serverPort").val()<1)
        {
            alert('Server Port = 1~65535');
            $("#serverPort").focus();
            return;
        }
        if($("#stationId").val()>65535 || $("#stationId").val()<1)
        {
            alert('Station ID = 1~65535');
            $("#stationId").focus();
            return;
        }
        if($("#dataTime").val()>86400 || $("#dataTime").val()<0)
        {
            alert('Data Update Period = 0~86400');
            $("#dataTime").focus();
            return;
        }
        if($("#heartTime").val()>86400)
        {
            alert('Heartbeat Period = 0~86400');
            $("#heartTime").focus();
            return;
        }
        if(parseInt($("#heartTime").val())>parseInt($("#dataTime").val()))
        {
            alert('"Heartbeat Period" must less "Data Update Period"');
            $("#heartTime").focus();
            return;
        }
        if($("#mbTimeout").val()>99999 || $("#mbTimeout").val()<50)
        {
            alert('Modbus Timer = 50~99999');
            $("#mbTimeout").focus();
            return;
        }

		document.forms["main_para"].submit();
	}


</script>
</head>

<body>
	<br>
	<form id="main_para" name="main_para" method="post" action="fw_rtuc_action.php"><br>
		<table align="center" border="1" cellpadding="2" cellspacing="2" width="600">
			<tbody>
				<tr align="center">
					<td id="page1" class="bg_d">Main Info.</td>
					<td id="page2" class="bg_l">Modbus Device</td>
					<td id="page3" class="bg_l">FTP / Email</td>
				</tr>
			</tbody>
		</table>
		<table align="center" border="1" cellpadding="2" cellspacing="2" width="600">
		<tbody>

		<tr>
			<td bgcolor="#ccffff">Server Address</td>
			<td ><input size="20" name="serverIp" value="<?php echo $rtuJson->serverIp;?>" ><br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Server Port</td>
			<td ><input size="20" id="serverPort" name="serverPort" value="<?php echo $rtuJson->serverPort;?>" maxlength=5
						onkeyup="this.value=this.value.replace(/[^0-9]/g,'')"> default=10000<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Station ID</td>
			<td ><input size="20" id="stationId" name="stationId" value="<?php echo $rtuJson->stationId;?>" maxlength=5
						onkeyup="this.value=this.value.replace(/[^0-9]/g,'')"> 1~65535<br>
			</td>
		</tr>

		<tr style="display:none">
			<td bgcolor="#ccffff">Device Type</td>
			<td ><input size="20" name="deviceType" value="<?php echo $rtuJson->deviceType;?>" ><br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Data Update Period(sec.)</td>
			<td ><input size="20" id="dataTime" name="dataTime" value="<?php echo $rtuJson->dataTime;?>" maxlength=5
						onkeyup="this.value=this.value.replace(/[^0-9]/g,'')"> 0~86400 (0=disable)<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Heartbeat Period(sec.)</td>
			<td ><input size="20" id="heartTime" name="heartTime" value="<?php echo $rtuJson->heartTime;?>" maxlength=5
						onkeyup="this.value=this.value.replace(/[^0-9]/g,'')"> 1~86400 (a day)<br>
			</td>
		</tr>

		<tr>
			<td colspan="2" bgcolor="#888888">
			</td>
		</tr>

		<!-- Modbus parameter -->
		<tr>
			<td bgcolor="#ccffff">Baud Rate (RS-485 for Modbus/RTU)</td>
			<td >
				<select name="buadrate">
				<option <?php if($rtuJson->buadrate == "115200") echo "selected"; ?> >115200</option>
				<option <?php if($rtuJson->buadrate == "57600") echo "selected"; ?> >57600</option>
				<option <?php if($rtuJson->buadrate == "38400") echo "selected"; ?> >38400</option>
				<option <?php if($rtuJson->buadrate == "19200") echo "selected"; ?> >19200</option>
				<option <?php if($rtuJson->buadrate == "9600") echo "selected"; ?> >9600</option>
				</select>
				bps
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Data Bit</td>
			<td >
				<select name="databit">
				<option <?php if($rtuJson->databit == "8") echo "selected"; ?> >8</option>
				<option <?php if($rtuJson->databit != "8") echo "selected"; ?> >7</option>
				</select>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Parity</td>
			<td >
				<select name="parity">
				<option <?php if($rtuJson->parity == "N") echo "selected"; ?> >N</option>
				<option <?php if($rtuJson->parity == "O") echo "selected"; ?> >O</option>
				<option <?php if($rtuJson->parity == "E") echo "selected"; ?> >E</option>
				</select>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Stop Bit</td>
			<td >
				<select name="stopbit">
				<option <?php if($rtuJson->stopbit == "1") echo "selected"; ?> >1</option>
				<option <?php if($rtuJson->stopbit == "2") echo "selected"; ?> >2</option>
				</select>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Modbus Timeout (ms)</td>
			<td ><input size="20" id="mbTimeout" name="mbTimeout" value="<?php echo $rtuJson->mbTimeout;?>" maxlength=5
						onkeyup="this.value=this.value.replace(/[^0-9]/g,'')"> 50~99999, default=1000<br>
			</td>
		</tr>

		<tr>
			<td colspan="2" bgcolor="#888888">
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Enable Firmware</td>
			<td ><input size="20" name="enable" type="checkbox" value="enable"<?php if($enable=="enable") echo "checked";?> >Enable <br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Alive</td>
			<?php
				if($alive == "true")
				{
					echo '<td bgcolor="#33ff33">True</td>'."\n";
				}else
				{
					echo '<td bgcolor="#cccccc">False</td>'."\n";
				}
			?>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Firmware Version</td>
			<td ><?php echo $rtuc_version;?></td>
		</tr>

		<tr align="center">
			<td colspan="2">
				<input name="button" value="Modify" type="button" OnClick="validateForm()">
				<input type="hidden" name="modifyType" value="base">
			</td>
		</tr>
		</tbody>
		</table>
	</form>
</body>
</html>

