#!/media/mmcblk0p1/usr/bin/python
# -*- coding: utf-8 -*-
#====================================

__version__ = 'V1.00 2014/08/26'

import time
from threading import Thread
import sys

from libRTUModbus import *
from libFTP import *
from libEmail import *
import os
import shutil
import ctypes   #for checking free space
import platform #for checking free space
import sys      #for checking free space
import socket
import select
from ctypes import cdll #for led & wdt share library
gl5klib = cdll.LoadLibrary("./libpygl5k.so")

# if True --> don't polling device, just set I/O randomly
IS_MODBUS_RANDOM = False
IS_THREAD_WORK = True
IS_CHECK_MMC = True
LED_FLAG = True
WDT_FLAG = True

rtuc = RtuClient_Modbus()

###################################
# get free space (cross platform)
###################################
def get_free_space_mb(folder):
    """ Return folder/drive free space (in bytes)
    """
    if platform.system() == 'Windows':
        free_bytes = ctypes.c_ulonglong(0)
        ctypes.windll.kernel32.GetDiskFreeSpaceExW(ctypes.c_wchar_p(folder), None, None, ctypes.pointer(free_bytes))
        return free_bytes.value/1024/1024
    else:#linux
        st = os.statvfs(folder)
        return st.f_bavail * st.f_frsize/1024/1024


##############################
# email, FTP report function
##############################
def mailThread():
    try:
        while(IS_THREAD_WORK):
            #-- (4) upload log file
            #- (4-1) copy and move log file
            localtime = time.localtime(time.time())
            # don't move file when 0 second to avoid 2 thread operate logFile at the same time
            if(localtime.tm_sec>5 and rtuc.isChangeLogFile() ):#true --> date chage
                #- copy log file to folder: "LOGFILE", "MAIL_UPLOAD", "FTP_UPLOAD"
                #   and remove last log file
                if(not os.path.exists(rtuc.log_dir)):
                    os.makedirs(rtuc.log_dir)
                if(not os.path.exists(rtuc.log_ftpDir)):
                    os.makedirs(rtuc.log_ftpDir)
                if(not os.path.exists(rtuc.log_mailDir)):
                    os.makedirs(rtuc.log_mailDir)
                logFileName = rtuc.lastLogFileName
                shutil.copy2(logFileName, rtuc.log_ftpDir)
                shutil.copy2(logFileName, rtuc.log_mailDir)
                if(get_free_space_mb(rtuc.log_dir)<200):#less 100 MB --> remove old logs
                    fileList = os.listdir(rtuc.log_dir)
                    for fileName in fileList:
                        os.remove(rtuc.log_dir+"/"+fileName)
                shutil.move(logFileName, rtuc.log_dir)

                #- (4-1) FTP upload
                if(rtuc.ftp_enable!="enable"):
                    shutil.rmtree(rtuc.log_ftpDir)
                else:
                    ftp_FFP = rtuc.log_ftpDir #os.getcwd()+"/"+rtuc.log_ftpDir #Full File Path
                    fileList = os.listdir(ftp_FFP)
                    errorCounter = 0
                    for i in range(len(fileList)):
                        res = ftp_upload(ftp_FFP+"/"+fileList[i], fileList[i], rtuc.ftp_serverAddr, rtuc.ftp_port \
                            , rtuc.ftp_username, rtuc.ftp_password, 'GRP-520_%d_log'%(rtuc.stationId) )
                        if(res == None):
                            rtuc.logInfo('->FTP upload success <' + fileList[i] +'>')
                            os.remove(ftp_FFP+"/"+fileList[i])
                        else:
                            rtuc.logError('->FTP fails <'+ fileList[i] +'>: ' + res)
                            errorCounter += 1
                        if(errorCounter>=3):
                            break
                        if(i>=10):
                            break

                #- (4-2) Email send
                if(rtuc.email_enable!="enable"):
                    shutil.rmtree(rtuc.log_mailDir)
                else:
                    mail_FFP = rtuc.log_mailDir #os.getcwd()+"/"+rtuc.log_mailDir
                    fileList = os.listdir(mail_FFP)
                    errorCounter = 0
                    for i in range(len(fileList)):
                        title = fileList[i]
                        res = sendEmail(rtuc.email_fromMail, rtuc.email_toMails, title, '', rtuc.email_username \
                            , rtuc.email_password, rtuc.email_mailServer, rtuc.email_mailPort, mail_FFP+"/"+fileList[i], fileList[i])
                        if(res == None):
                            rtuc.logInfo('->email report success <' + fileList[i] +'>')
                            os.remove(mail_FFP+"/"+fileList[i])
                        else:
                            rtuc.logError('->Email Fails <'+ fileList[i] +'>: ' + res)
                            errorCounter += 1
                        if(errorCounter>=3):
                            break
                        if(i>=10):
                            break
            time.sleep(1)

    except Exception, e:
        rtuc.logError("Mail/FTP Thread Exception->" + str(e))


#===========================
#== Modbus Thread Function
#===========================
def modbusThread():
    try:
        while(IS_THREAD_WORK):
            strTime = time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(time.time()))
            #-- (2) deal mb data
            #rtuc.enable_debug()
            if(IS_MODBUS_RANDOM):
                rtuc.setRtuDataRandom(True)
            else:
                res = rtuc.poll_modbus()
                if(res!=None):
                    print ("[%s] modbus error\r\n" %(strTime)) + res

            #- deal RTU command
            rtuc.deal_command()

            time.sleep(0.2)
    except Exception, e:
        rtuc.logError("Modbus Thread Exception->" + str(e))


#===========================
#== RTU Thread Function
#===========================
def rtuThread():
    #-- send rtu data
    BUFSIZ = 1024
    tcpCliSock = None
    tmRtuData = 0
    tmRtuHeartBeat = 0

    rtuPacketType = 0 #-1=None, 0=initial, 1=data, 2=heartbeat
    while True:
        msTime = getMsTime()
        #-- (1) Connect RTU Center, and send initial, data packet, heartbeat
        try:
            if(tcpCliSock==None): #still not connect
                #- (1-1) connect and Initial Packet
                server_addr = (rtuc.serverIp, rtuc.serverPort)
                try:
                    tcpCliSock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
                    tcpCliSock.settimeout(5)
                    tcpCliSock.connect(server_addr)
                    rtuc.logInfo("<1-1-1>Success to connect Server")
                    rtuPacketType = 0
                except socket.timeout:
                    rtuc.logInfo("<1-1-2>net_connect timeout")
                    tcpCliSock = None
                except Exception, e:
                    rtuc.logInfo("<1-1-3>net_connect Exception: " + str(e))
                    tcpCliSock = None
            else:
                #- (1-2) make initial, data or heartbeat packet data
                if(rtuPacketType==0):
                    data = rtuc.makeInitPack()
                elif(rtuPacketType<0):
                    if (msTime-tmRtuData>=(rtuc.dataTime*1000) ):
                        tmRtuData = msTime
                        data = rtuc.makeDataPack()
                        rtuPacketType = 1
                        strTime = time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(time.time()))
                        print ("[%s] Send RTU Data" %(strTime))
                    elif (rtuc.heartTime>0 and (msTime-tmRtuHeartBeat>=(rtuc.heartTime*1000)) ):
                        tmRtuHeartBeat = msTime
                        data = rtuc.makeHeartPack()
                        rtuPacketType = 2
                #- (1-3) send packet
                if(rtuPacketType>=0):
                    try:
                        tcpCliSock.send(data)
                    except socket.timeout:
                        rtuc.logInfo("<1-3-1>net_send timeout, PacketType=%d" %(rtuPacketType))
                        tcpCliSock.close()
                        tcpCliSock = None
                    except Exception, e:
                        rtuc.logInfo("<1-3-2>net_send exception, Packettype=%d: %s" %(rtuPacketType, str(e)))
                        tcpCliSock.close()
                        tcpCliSock = None
                    rtuPacketType = -1

                #- (1-4) receive RTU command
                inputready, outputready, exceptready = select.select([tcpCliSock], [], [], 0.001)
                if(inputready):
                    try:
                        data = tcpCliSock.recv(BUFSIZ)
                        rtuc.logInfo("recv_data len = %d" %(len(data)))
                        if(len(data)==0):
                            rtuc.logInfo("data length = 0 --> socket disconnect")
                            tcpCliSock.close()
                            tcpCliSock = None
                        else:
                            rtuc.checkCommand(data)
                    except socket.timeout:
                        rtuc.logInfo("<1-4-1>net_recv timeout")
                        data = None
                    except Exception, e:
                        rtuc.logInfo("<1-4-2>net_recv exception: " + str(e))
                        data= None
                        tcpCliSock.close()
                        tcpCliSock = None
        except Exception, e:
            rtuc.logInfo("<1-1>Net Error: " + str(e))

        time.sleep(0.2)



def getMsTime():
    """
    get millisecond time value
    """
    return int(time.time() * 1000)


def readModemInfo(modemInfo):
    """
    read modem infomation
    """
    modemInfo["cpin"] ="Not Ready"
    modemInfo["creg"] = "0"
    modemInfo["csq"] = "0"
    modemInfo["ppp0"] = "0"
    try:
        with open("/icpdas/modemInfo.txt", 'r') as fp:
            lines = fp.readlines()
            for line in lines:
                line = line.strip("\r\n")
                items = line.split("=")
                if(items[0]=="cpintype"):
                    modemInfo["cpin"] = items[1]
                elif(items[0]=="cregvalue"):
                    modemInfo["creg"] = items[1]
                elif(items[0]=="csqvalue"):
                    modemInfo["csq"] = items[1]
                elif(items[0]=="ppp0"):
                    modemInfo["ppp0"] = items[1]
        return None
    except Exception, e:
        return str(e)


##############################
# main start
##############################
def main():
    mmcUmountCounter = 0 # to check SD/mmc

    if(len(sys.argv)>1):
        if(sys.argv[1]=='--ver'):
            print 'GRP-520 RTU Client = ' + __version__
        else:
            print 'GRP-520 RTU Client version = ' + __version__
            print ' --ver : to get version'
            print ' no parameter : to execute the program'
        return

    if(LED_FLAG):
        gl5klib.py_led_init()
    if(WDT_FLAG):
        gl5klib.py_wdt_init()
        gl5klib.py_wdt_enable(5000)

    rtuc.enable_debug(rtuc.DLOG_INFO)
    rtuc.readConfig()

    print 'GRP-520 RTU Client = ' + __version__
    rtuc.logInfo('Start GRP-520 RTU Client : ' + __version__)

    #- remove all old csv files
    fileList = os.listdir("./")
    for logFileName in fileList:
        ext = os.path.splitext(logFileName)
        if(ext[1]==".csv"):
            os.remove(logFileName)

    #- store modem information
    modemInfo = dict()
    readModemInfo(modemInfo)

    #- start thread
    thread_mail = Thread(target=mailThread)
    time.sleep(0.1)
    thread_mail.start()
    thread_modbus = Thread(target=modbusThread)
    time.sleep(0.1)
    thread_modbus.start()
    if rtuc.dataTime!=0: #if rtu data time=0 --> RTU client stop
        thread_rtu = Thread(target=rtuThread)
        time.sleep(0.1)
        thread_rtu.start()

    tmWDT = 0 # ms
    tmModemInfo = 0
    while True:
        try:
            #-- main process loop
            msTime = getMsTime()

            #-- (3) datalog
            res = rtuc.makeLog()
            if(res!=None):
                rtuc.logError(res)

            #-- (5) read Modem Information
            if(msTime-tmModemInfo>=2000):
                tmModemInfo = msTime
                res = readModemInfo(modemInfo)
                if(res!=None):
                    rtuc.logError("<1-5>readModemInfo: " + res)
                netPriority = 2<<4
                if(modemInfo["ppp0"]=="1"):
                    rtuc.netInterface = 0 + netPriority #gprs
                else:
                    rtuc.netInterface = 1 + netPriority #ethernet

            #-- (6) check thread working or not
            try:
                if not thread_mail.isAlive():
                    thread_mail = Thread(target=mailThread)
                    time.sleep(0.1)
                    thread_mail.start()
                    rtuc.logInfo("Restart mail Thread")
                if not thread_modbus.isAlive():
                    thread_modbus = Thread(target=modbusThread)
                    time.sleep(0.1)
                    thread_modbus.start()
                    rtuc.logInfo("Restart Modbus Thread")

                if rtuc.dataTime!=0 and (not thread_rtu.isAlive()):
                    thread_rtu = Thread(target=rtuThread)
                    time.sleep(0.1)
                    thread_rtu.start()
                    rtuc.logInfo("Restart RTU Thread")
            except Exception, e:
                rtuc.logInfo("<1-6>check thread exception: " + str(e))


            #-- (7) check SD/mmc card
            try:
                if(IS_CHECK_MMC):
                    if(not os.path.exists("/dev/mmcblk0p1")):
                        mmcUmountCounter += 1
                        rtuc.logError("SD Card disappear!!")
                        if(mmcUmountCounter>10):
                            gl5klib.py_wdt_reset()
                    else:
                        mmcUmountCounter = 0
            except Exception, e:
                rtuc.logInfo("<1-7>check SD card exception: " + str(e))


            #-- (8) Status Led
            try:
                msStaLed = getMsTime()
                if(LED_FLAG):
                    if (msStaLed%1000>500):
                        gl5klib.py_led_set(2, 0)
                    else:
                        gl5klib.py_led_set(2, 1)
            except Exception, e:
                rtuc.logInfo("<1-8>Status Led exception: " + str(e))


            #-- (9) WDT
            try:
                if(WDT_FLAG):
                    if(msTime-tmWDT>=2000):
                        tmWDT = msTime
                        gl5klib.py_wdt_refresh()
            except Exception, e:
                rtuc.logInfo("<1-9>Status Led exception: " + str(e))


        except Exception, e:
            rtuc.logError("Main Process Loop Exception->" + str(e))

        time.sleep(0.1)

    print 'exit'
    tcpCliSock.close()

if __name__ == '__main__':
    main()


