#!/usr/bin/php
<?php

$retryInterval=60;//sec.
$lastTime = "";
$rebootLog = '/icpdas/rebootTimer/tm.log';

if($argc==1)
{
	$data=file_get_contents("/icpdas/rebootTimer/rebootTimer.ini");
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);
		if($line[0]=='#') continue;

		list($name , $value)=split('=' , $line);
		if($name == "interval")
		{
			$retryInterval = ((int)$value)*60*60;//hours
		}
		else if($name == "lastTime")
		{
			$lastTimeString = $value;
		}
	}
}
if($argc>=2)
{
	if($argv[1]=="--help")
	{
		echo "Usage: gprsMonitor time\n";
		echo "  time:    interval time to reboot\n";
		echo "  (version = v1.0 2013/12/27)\n";
	}
	return;
}
if(true)
{
	echo "  retryInterval = ".$retryInterval."\n";
	echo "  lastTime = ". $lastTimeString. "\n";
	//return;
}

if($lastTimeString=="")
{
    $lastTime = time();
}

echo "--> start\n";
logTime("start", $rebootLog);

while(1)
{
	// Prints something like: 2013/12/27 11:09:00
	echo "-->Now: [" .date('Y/m/d H:i:s') ."]\n";
	$dTime = (time()-$lastTime);
	echo "--> now()-lastTime: " .$dTime ."\n";

	if($dTime<$retryInterval)
	{
		echo "  sleep\n";
		sleep(10);
	}
	else
	{
        logTime("reboot system", $rebootLog);

		echo "  reboot system\n";
		exec('reboot');
		sleep(3600);//if reboot fail, retry it after 1 hour
	}
}

function logTime($message="", $logFile)
{
    $MAX_LINE = 1000;
    $info = file_get_contents($logFile);
    $info_array = explode("\n", $info);
    $lineNum = sizeof($info_array);
    //最多保留1000筆 (約10kB)
    if($lineNum<$MAX_LINE)
    {
        $info_array[] = ("[".date('Y/m/d H:i:s')."] " .$message );
    }else
    {
        $info_array = array_slice($info_array, -1*$MAX_LINE, $MAX_LINE);
        $info_array[] = ("[".date('Y/m/d H:i:s')."] " .$message );
    }
    $data=implode("\n",$info_array);
    file_put_contents($logFile,$data);
}
/*
/icpdas/rebootTimer # ./rebootTimer.php
  retryInterval = 60
  lastTime =
-->Now: [2013/12/26 10:59:58 AM]
--> now()-lastTime: 0
  sleep
-->Now: [2013/12/26 11:00:08 AM]
--> now()-lastTime: 10
  sleep
-->Now: [2013/12/26 11:00:18 AM]
--> now()-lastTime: 20
  sleep
-->Now: [2013/12/26 11:00:28 AM]
--> now()-lastTime: 30
  sleep
-->Now: [2013/12/26 11:00:38 AM]
--> now()-lastTime: 40
  sleep
-->Now: [2013/12/26 11:00:48 AM]
--> now()-lastTime: 50
  sleep
-->Now: [2013/12/26 11:00:58 AM]
--> now()-lastTime: 60
  reboot system
Terminated
/icpdas/rebootTimer #

*/
?>

