
<html>
<head>
<meta content="text/html; charset=UTF-8" http-equiv="content-type">
<title></title>
</head>

<body>
<?php
//====================================
//== get and setting DDNS configure ==
//====================================
require_once("./class.php");

//== get DHCPD configuration
function getDhcpdCfg(&$dhcpdInfo)
{
	//get dhcpd config
	$info = file_get_contents(CommonData::$DHCPD_SETTING_FILE);
	$info_array = explode("\n", $info);

	$info = strstr($info, "subnet");
	strtok($info, " ");
	$dhcpdInfo["subnet"] = strtok(" ");

	$info = strstr($info, "netmask");
	strtok($info, " ");
	$dhcpdInfo["netmask"] = strtok(" ");

	$info = strstr($info, "default-lease-time");
	strtok($info, " ");
	$dhcpdInfo["default-lease-time"] = strtok(";");

	$info = strstr($info, "max-lease-time");
	strtok($info, " ");
	$dhcpdInfo["max-lease-time"] = strtok(";");

	$info = strstr($info, "domain-name-servers");
	strtok($info, " ");
	$dhcpdInfo["domain-name-servers"] = strtok(";");

	$info = strstr($info, "broadcast-address");
	strtok($info, " ");
	$dhcpdInfo["broadcast-address"] = strtok(";");

	$info = strstr($info, "routers");
	strtok($info, " ");
	$dhcpdInfo["routers"] = strtok(";");

	$info = strstr($info, "range");
	strtok($info, " ");
	$dhcpdInfo["range_from"] = strtok(" ");
	$dhcpdInfo["range_to"] = strtok(";");

	//check Start sh in "/etc/init.d/"
	if(file_exists("/etc/init.d/S" .CommonData::$DHCPD_RUN_SCRIPT))
		$dhcpdInfo["enable"]="enable";
	else
		$dhcpdInfo["enable"]="disable";
}

//== set DHCPD configuration
function setDhcpdCfg($dhcpdInfo)
{
	//set dhcpd config
	$new_info = "ddns-update-style none;\n\n";
	$new_info .= "subnet " .$dhcpdInfo["subnet"] ." netmask " .$dhcpdInfo["netmask"] ." {\n";
	$new_info .= "\t" ."default-lease-time " .$dhcpdInfo["default-lease-time"] .";\n";
	$new_info .= "\t" ."max-lease-time " .$dhcpdInfo["max-lease-time"] .";\n";
	$new_info .= "\t" ."option domain-name-servers " .$dhcpdInfo["domain-name-servers"] .";\n";
	$new_info .= "\t" ."option broadcast-address " .$dhcpdInfo["broadcast-address"] .";\n";
	$new_info .= "\t" ."option routers " .$dhcpdInfo["routers"] .";\n";
	$new_info .= "\t" ."range " .$dhcpdInfo["range_from"] ." " .$dhcpdInfo["range_to"] ."; }\n";
	$new_info .= "\n";

	file_put_contents(CommonData::$DHCPD_SETTING_FILE, $new_info);

	//set Start sh in "/etc/init.d/"
	$dhcpd_content =
        "\n"
        ."case \"$1\" in\n"
        ."  start)\n"
        ."      echo \"Starting dhcpd :\"\n"
        ."      touch /var/lib/dhcp/dhcpd.leases\n"
        ."      /usr/sbin/dhcpd\n"
        ."      echo \"OK\"\n"
        ."      ;;\n"
        ."  stop)\n"
        ."      echo \"Stopping dhcpd: \"\n"
        ."      killall dhcpd\n"
        ."      echo \"OK\"\n"
        ."      ;;\n"
        ."  restart|reload)\n"
        ."      \"$0\" stop\n"
        ."      \"$0\" start\n"
        ."      ;;\n"
        ."  *)\n"
        ."  echo $\"Usage: $0 {start|stop|restart}\"\n"
        ."  exit 1\n"
        ."esac\n"
        ."exit $?\n";

    if(file_exists("/etc/init.d/S" .CommonData::$DHCPD_RUN_SCRIPT))
        unlink("/etc/init.d/S" .CommonData::$DHCPD_RUN_SCRIPT);
    if(file_exists("/etc/init.d/K" .CommonData::$DHCPD_RUN_SCRIPT))
        unlink("/etc/init.d/K" .CommonData::$DHCPD_RUN_SCRIPT);

	if($dhcpdInfo["enable"]=="enable")
	{
        file_put_contents("/etc/init.d/S" .CommonData::$DHCPD_RUN_SCRIPT, $dhcpd_content);
        shell_exec("chmod +x " ."/etc/init.d/S" .CommonData::$DHCPD_RUN_SCRIPT);
	}else
	{
        file_put_contents("/etc/init.d/K" .CommonData::$DHCPD_RUN_SCRIPT, $dhcpd_content);
	}
}

/*
case "$1" in
  start)
        echo -n "Starting dhcpd :"
        touch /var/lib/dhcp/dhcpd.leases
        /usr/sbin/dhcpd
        echo "OK"
        ;;
  stop)
        echo -n "Stopping dhcpd: "
        killall dhcpd
        echo "OK"
        ;;
  restart|reload)
        "$0" stop
        "$0" start
        ;;
  *)
        echo $"Usage: $0 {start|stop|restart}"
        exit 1
esac

exit $?
*/

//-- set DDNS configure
if($_POST["submit"]=="Modify")	//press "Modify" button
{
	//print_r($_POST);
	getDhcpdCfg(&$dhcpdInfo);

	$dhcpdInfo["subnet"] = trim($_POST["subnet"]);
	$dhcpdInfo["netmask"] = trim($_POST["netmask"]);
	$dhcpdInfo["default-lease-time"] = trim($_POST["default-lease-time"]);
	$dhcpdInfo["routers"] = trim($_POST["routers"]);
	$dhcpdInfo["range_from"] = trim($_POST["range_from"]);
	$dhcpdInfo["range_to"] = trim($_POST["range_to"]);
	$dhcpdInfo["enable"] = trim($_POST["enable"]);
	//print_r($dhcpdInfo);

	if(isIP($dhcpdInfo["subnet"]) && isIP($dhcpdInfo["routers"]) && isIP($dhcpdInfo["range_from"])
		&& isIP($dhcpdInfo["range_to"]))
	{
		setDhcpdCfg(&$dhcpdInfo);
		echo "<div align=\"center\"><font color=\"#cc0000\">setting success!!</font><br>\n";
		echo "<div align=\"center\"><font color=\"#cc0000\">Please reboot to enable setting!!</font><br>\n";
	}else
	{
		echo "<div align=\"center\"><font color=\"#cc0000\">Configure Error!!</font><br>\n";
	}
	// read again!
	getDhcpdCfg(&$dhcpdInfo);
}else
{
	//-- DHCP Server config
	getDhcpdCfg(&$dhcpdInfo);
}

//- get eth0 IP setting
$eth0 = new Network("eth0");
$eth0->getNetConfig();
$my_address = $eth0->address;
?>


	<br>
	<form method="post" name="form1"><br><!-- 加入 action="aa.html" 可以指定給誰處理 -->
		<table align="center" border="1" cellpadding="2" cellspacing="2" width="600">
		<tbody>

		<tr align="center">
			<td colspan="2" bgcolor="#ffcc99">DHCP Server<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff" width="200">Subnet</td>
			<td><input size="20" name="subnet" value="<?php echo $dhcpdInfo["subnet"];?>" readonly>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Netmask</td>
			<td ><input size="20" name="netmask" value="<?php echo $dhcpdInfo["netmask"];?>" readonly><br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Lease-time</td>
			<td ><input size="20" name="default-lease-time" value="<?php echo $dhcpdInfo["default-lease-time"];?>" readonly><br>
			</td>
		</tr>

		<tr title="usually setting router IP as device IP">
			<td bgcolor="#ccffff">Router</td>
			<td ><input size="20" name="routers" value="<?php echo $dhcpdInfo["routers"];?>" > device IP=<?php echo $my_address;?><br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Range</td>
			<td >
				<input size="20" name="range_from" value="<?php echo $dhcpdInfo["range_from"];?>" >
				~
				<input size="20" name="range_to" value="<?php echo $dhcpdInfo["range_to"];?>" >
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Enable</td>
			<td ><input size="20" name="enable" type="checkbox" value="enable"<?php if($dhcpdInfo["enable"]=="enable") echo "checked";?> >Enable <br>
			</td>
		</tr>

		<tr align="center">
			<td colspan="2"><input name="submit" value="Modify" type="submit"><br>
			</td>
		</tr>

		</tbody>
		</table>

		<br>
		<br>
	</form>
	<br>
	<br>
</body>
</html>



