#!/usr/bin/php
<?php

$serverIP="www.google.com";
$maxRetry=3;
$retryInterval=30;
$GSM_Timeout=60;
$maxGSMReset = 100;//default 2 minutes x 100 = 200 minutes will reboot
$GSM_shutdownDelay = 10;
$logFile = '/icpdas/gprsm/gprsm.log';

if($argc==1)
{
	$data=file_get_contents("/icpdas/gprsm/gprsm.ini");
	$array_data=explode("\n",$data);

	foreach ($array_data as $index =>$line)
	{
		$line=trim($line);
		if($line[0]=='#') continue;

		list($name , $value)=split('=' , $line);
		if($name == "serverIP"){
			$serverIP = $value;
		}else if($name == "maxRetry")
		{
			$maxRetry = (int)$value;
		}else if($name == "interval")
		{
			$retryInterval = (int)$value;
		}else if($name == "timeout")
		{
			$GSM_Timeout = $value;
		}
	}
}
if($argc>=2)
{
	if($argv[1]=="--help")
	{
		echo "Usage: gprsMonitor IP [n [interval [timeout]]]\n";
		echo "  IP:          target IP for ping\n";
		echo "  n:           continue check until n time, and then system will reboot\n";
		echo "  interval:    interval time to re-check again\n";
		echo "  timeout:     if connecting 3G network fails in 30 seconds(default), it will restart 3G module\n";
		echo "  (version = v1.1.1 2014/01/13)\n";
		return;
	}else if($argv[1]=="--ver")
	{
        echo "version = v1.1.1 2014/01/13\n";
        return;
	}
	else
		$serverIP=$argv[1];
}
if($argc>=3)
	$maxRetry=(int)$argv[2];
if($argc>=4)
	$retryInterval=(int)$argv[3];
if($argc>=5)
	$GSM_Timeout=(int)$argv[4];

if(true)
{
	echo "  serverIP = ".$serverIP."\n";
	echo "  maxRetry = ".$maxRetry."\n";
	echo "  retryInterval = ".$retryInterval."\n";
	echo "  GSM_Timeout = ".$GSM_Timeout."\n";
	logTime("==== gprsMonitor start ====", $logFile);
	logTime("serverIP=".$serverIP.", "
            ."maxRetry=".$maxRetry.", "
            ."retryInterval=".$retryInterval.", "
            ."GSM_Timeout=".$GSM_Timeout.", "
            ."maxGSMReset=".$maxGSMReset, $logFile);
	//return;
}

$retry_n = 0;
$resetGSM_n = 0;
while(1)
{
	$retry_n++;
	// Prints something like: 2013/12/27 11:09:00 AM
	echo "-->ping test [" .date('Y/m/d h:i:s A') ."]\n";

	$result = exec('ping ' .$serverIP .' -I ppp0 -c 3|grep "time="');

	if(strlen($result))
	{
		echo "  ping success\n";
		$retry_n = 0;
	}
	else
	{
		echo "  ping fail[" .$retry_n ."]\n";
        logTime("ping fail[" .$retry_n ."]", $logFile);
		if($retry_n>=$maxRetry)
		{
			$retry_n = 0;
			$resetGSM_n++;
			logTime("soft shutdown Modem, delay:" .$GSM_shutdownDelay ." sec.", $logFile);
			echo "soft shutdown Modem\n";
            exec('echo -e "AT+CPOF\r\n" > /dev/ttyUSB2');
            sleep($GSM_shutdownDelay);
            logTime("power reset GSM[" .$resetGSM_n ."]", $logFile);
            echo "power off GSM[" .$resetGSM_n ."]\n";
			exec('echo 0 > /proc/ICPDAS/GPRS_Power');
			sleep(1);
			echo "power on GSM\n";
			exec('echo 1 > /proc/ICPDAS/GPRS_Power');
			echo "sleep(" .$GSM_Timeout .")\n";
			sleep($GSM_Timeout);
		}

		if($resetGSM_n>=$maxGSMReset)
		{
            $resetGSM_n=0;
            logTime("reboot system", $logFile);
            echo "  reboot system\n";
            exec('reboot');
            sleep(60);//if reboot fail, retry it after 1 minute
		}
	}
	sleep($retryInterval);
}

function logTime($message="", $logFile)
{
    $MAX_LINE = 1000;
    $info = file_get_contents($logFile);
    $info_array = explode("\n", $info);
    $lineNum = sizeof($info_array);
    //1000 log (約10kB)
    if($lineNum<$MAX_LINE)
    {
        $info_array[] = ("[".date('Y/m/d H:i:s')."] " .$message );
    }else
    {
        $info_array = array_slice($info_array, -1*$MAX_LINE, $MAX_LINE);
        $info_array[] = ("[".date('Y/m/d H:i:s')."] " .$message );
    }
    $data=implode("\n",$info_array);
    file_put_contents($logFile,$data);
}
?>

