
<html>
<head>
<meta content="text/html; charset=UTF-8" http-equiv="content-type">
<title></title>
</head>

<body>
<?php
//====================================
//== get and setting vxsc(vxserver client) parameter ==
//====================================

require_once("./class.php");


if($_POST["submit"]=="Modify")	//press "Modify" button
{
	$serverIP = trim($_POST["serverIP"]);
	$serverPort = trim($_POST["serverPort"]);
	$heartbeatTime = trim($_POST["heartbeatTime"]);
	$deviceID = trim($_POST["deviceID"]);//virtualIP = "127.0.20." + deviceID
	$moduleAlias = trim($_POST["moduleAlias"]);
	$TimeInterval = trim($_POST["TimeInterval"]);
	$UartDataMax = trim($_POST["UartDataMax"]);
	$IsTCP2RTU1 = trim($_POST["IsTCP2RTU1"]);
	$IsTCP2RTU2 = trim($_POST["IsTCP2RTU2"]);
	$Baudrate1 = trim($_POST["Baudrate1"]);
	$Baudrate2 = trim($_POST["Baudrate2"]);
	$Format1 = trim($_POST["Format1"]);
	$Format2 = trim($_POST["Format2"]);
	$enable = $_POST["enable"];

	$isParaRight = true;
	if(!isIP($serverIP))
	{
		echo "<div align=\"center\"><font color=\"#cc0000\">Server IP Error</font><br>\n";
		$isParaRight = false;
	}
	if(intval($serverPort)<1 || intval($serverPort)>65535)
	{
		echo "<div align=\"center\"><font color=\"#cc0000\">Server Port Error</font><br>\n";
		$isParaRight = false;
	}
	if(intval($heartbeatTime)<10 || intval($heartbeatTime)>65535)
	{
		echo "<div align=\"center\"><font color=\"#cc0000\">Heartbeat Time Error</font><br>\n";
		$isParaRight = false;
	}
	if(intval($deviceID)<0 || intval($deviceID)>255)
	{
		echo "<div align=\"center\"><font color=\"#cc0000\">Device ID Error</font><br>\n";
		$isParaRight = false;
	}else
		$virtualIP = "127.0.20." .$deviceID;

	if(intval($TimeInterval)<1 || intval($TimeInterval)>5000)
	{
		echo "<div align=\"center\"><font color=\"#cc0000\">Time Interval Error. Using default value</font><br>\n";
		$isParaRight = false;
	}
	if(intval($UartDataMax)<10 || intval($UartDataMax)>1000)
	{
		echo "<div align=\"center\"><font color=\"#cc0000\">Data Length Error. Using default value</font><br>\n";
		$isParaRight = false;
	}

	if(intval($IsTCP2RTU1)!=1)
		$IsTCP2RTU1 = 0;
	if(intval($IsTCP2RTU2)!=1)
		$IsTCP2RTU2 = 0;

	//-- auto-run manage
	if($enable=="enable")
		$enable="enable";
	else
		$enable="disable";

	if($isParaRight) //if parameter is correct
	{
		$proc_name = CommonData::$VXSC_EXE;
		$full_file_name = CommonData::$VXSC_DIR ."/" .$proc_name;
		addUserProc("VxServer", $full_file_name, CommonData::$VXSC_DIR ."/kill_vxsc.sh", $full_file_name, $enable);
		getUserProcCgf($proc_list);
		setAutoRunFW($proc_list);

		//-- set vxsc configure into vxserver.ini
		setVxscInfo($serverIP, $serverPort, $heartbeatTime, $virtualIP, $moduleAlias, $TimeInterval, $UartDataMax
			, $IsTCP2RTU1, $IsTCP2RTU2, $Baudrate1, $Baudrate2, $Format1, $Format2);

		echo "<div align=\"center\"><font color=\"#0000cc\">setting success!!</font><br>\n";

		//-- Start/Stop firmware
		$n = count($proc_list);
		for($i=0; $i<$n; $i++)
		{
			if($proc_list[$i]["exec"] == $full_file_name)
			{
				//enable--> restart FW
				if($enable=="enable")
				{
					shell_exec($proc_list[$i]["stop"]);
					pclose(popen($proc_list[$i]["start"] ." &", "r"));//put into backgroud, or php will be block
					echo "<div align=\"center\"><font color=\"#0000cc\">Execute ".$proc_list[$i]["name"]." successfully</font><br>\n";
					break;
				}else
				{
					shell_exec($proc_list[$i]["stop"]);
					echo "<div align=\"center\"><font color=\"#0000cc\">Stop ".$proc_list[$i]["name"]." successfully</font><br>\n";
					break;
				}
			}
		}
	}
}

//READ INFORMATION
getVxscInfo($serverIP, $serverPort, $heartbeatTime, $virtualIP, $moduleAlias, $TimeInterval, $UartDataMax
	, $IsTCP2RTU1, $IsTCP2RTU2, $Baudrate1, $Baudrate2, $Format1, $Format2, $enable, $vxsc_alive, $vxsc_version);
if($TimeInterval<1 || $TimeInterval>5000) $TimeInterval=50;
if($UartDataMax<10 || $UartDataMax>1000) $UartDataMax=1000;
if(intval($IsTCP2RTU1)!=1) $IsTCP2RTU1 = 0;
if(intval($IsTCP2RTU2)!=1) $IsTCP2RTU2 = 0;
if(intval($Baudrate1)=="") $Baudrate1 = "115200";
if(intval($Baudrate2)=="") $Baudrate2 = "115200";
if(intval($Format1)=="") $Format1 = "8N1";
if(intval($Format2)=="") $Format2 = "8N1";

$deviceID = substr($virtualIP, strlen("127.0.20."));//127.0.20.xxx
?>

	<br>
	<form method="post" name="ethernet"><br>
		<table align="center" border="1" cellpadding="2" cellspacing="2" width="600">
		<tbody>

		<tr align="center">
			<td colspan="2" bgcolor="#ffcc99">Virtual COM Function (VxServer)<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff" width="200">Server IP</td>
			<td ><input size="20" name="serverIP" value="<?php echo $serverIP;?>" maxlength=15
						onkeyup="this.value=this.value.replace(/[^0-9.]/g,'')"><br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Server Port</td>
			<td ><input size="20" name="serverPort" value="<?php echo $serverPort;?>" maxlength=5
						onkeyup="this.value=this.value.replace(/[^0-9]/g,'')"> default=11000 <br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Heartbeat Time</td>
			<td ><input size="20" name="heartbeatTime" value="<?php echo $heartbeatTime;?>" maxlength=5
						onkeyup="this.value=this.value.replace(/[^0-9]/g,'')"> 10~65535 seconds<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Device ID</td>
			<td ><input size="20" name="deviceID" value="<?php echo $deviceID;?>" maxlength=3
						onkeyup="this.value=this.value.replace(/[^0-9]/g,'')"> 1~255, unique ID for device<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Alias</td>
			<td ><input size="20" name="moduleAlias" value="<?php echo $moduleAlias;?>" maxlength=8
						onkeyup="this.value=this.value.replace(/[^a-zA-Z0-9_-]/g,'')"> Max. Length = 8<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Time Interval</td>
			<td ><input size="20" name="TimeInterval" value="<?php echo $TimeInterval;?>" maxlength=4
						onkeyup="this.value=this.value.replace(/[^0-9]/g,'')"> 1~5000 ms, default=50<br>
			</td>
		</tr>

		<tr title="Serial port data will be sliced into small network packets dependenting on this value">
			<td bgcolor="#ccffff">Data Length</td>
			<td ><input size="20" name="UartDataMax" value="<?php echo $UartDataMax;?>" maxlength=4
						onkeyup="this.value=this.value.replace(/[^0-9]/g,'');"> 10~1000 bytes, default=1000<br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Modbus TCP to RTU (Port1)</td>
			<td >
				<select name="IsTCP2RTU1">
				<option value=1 <?php if($IsTCP2RTU1 == 1) echo "selected"; ?> >True</option>
				<option value=0 <?php if($IsTCP2RTU1 != 1) echo "selected"; ?> >False</option>
				</select>
				COM2 of GRP-520 --> TCP Port 10001
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Modbus TCP to RTU (Port2)</td>
			<td >
				<select name="IsTCP2RTU2">
				<option value=1 <?php if($IsTCP2RTU2 == 1) echo "selected"; ?> >True</option>
				<option value=0 <?php if($IsTCP2RTU2 != 1) echo "selected"; ?> >False</option>
				</select>
				COM3 of GRP-520 --> TCP Port 10002
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Default Baudrate (Port1)</td>
			<td >
				<select name="Baudrate1">
				<option <?php if($Baudrate1 == "115200") echo "selected"; ?> >115200</option>
				<option <?php if($Baudrate1 == "57600") echo "selected"; ?> >57600</option>
				<option <?php if($Baudrate1 == "38400") echo "selected"; ?> >38400</option>
				<option <?php if($Baudrate1 == "19200") echo "selected"; ?> >19200</option>
				<option <?php if($Baudrate1 == "9600") echo "selected"; ?> >9600</option>
				</select>
				bps
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Default Baudrate (Port2)</td>
			<td >
				<select name="Baudrate2">
				<option <?php if($Baudrate2 == "115200") echo "selected"; ?> >115200</option>
				<option <?php if($Baudrate2 == "57600") echo "selected"; ?> >57600</option>
				<option <?php if($Baudrate2 == "38400") echo "selected"; ?> >38400</option>
				<option <?php if($Baudrate2 == "19200") echo "selected"; ?> >19200</option>
				<option <?php if($Baudrate2 == "9600") echo "selected"; ?> >9600</option>
				</select>
				bps
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Default Format (Port1)</td>
			<td >
				<select name="Format1">
				<option <?php if($Format1 == "8N1") echo "selected"; ?> >8N1</option>
				<option <?php if($Format1 == "8O1") echo "selected"; ?> >8O1</option>
				<option <?php if($Format1 == "8E1") echo "selected"; ?> >8E1</option>
				<option <?php if($Format1 == "8N2") echo "selected"; ?> >8N2</option>
				<option <?php if($Format1 == "8O2") echo "selected"; ?> >8O2</option>
				<option <?php if($Format1 == "8E2") echo "selected"; ?> >8E2</option>
				<option <?php if($Format1 == "7N1") echo "selected"; ?> >7N1</option>
				<option <?php if($Format1 == "7O1") echo "selected"; ?> >7O1</option>
				<option <?php if($Format1 == "7E1") echo "selected"; ?> >7E1</option>
				<option <?php if($Format1 == "7N2") echo "selected"; ?> >7N2</option>
				<option <?php if($Format1 == "7O2") echo "selected"; ?> >7O2</option>
				<option <?php if($Format1 == "7E2") echo "selected"; ?> >7E2</option>
				</select>
				(Data bit, Parity, Stop bit)
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Default Format (Port2)</td>
			<td >
				<select name="Format2">
				<option <?php if($Format2 == "8N1") echo "selected"; ?> >8N1</option>
				<option <?php if($Format2 == "8O1") echo "selected"; ?> >8O1</option>
				<option <?php if($Format2 == "8E1") echo "selected"; ?> >8E1</option>
				<option <?php if($Format2 == "8N2") echo "selected"; ?> >8N2</option>
				<option <?php if($Format2 == "8O2") echo "selected"; ?> >8O2</option>
				<option <?php if($Format2 == "8E2") echo "selected"; ?> >8E2</option>
				<option <?php if($Format2 == "7N1") echo "selected"; ?> >7N1</option>
				<option <?php if($Format2 == "7O1") echo "selected"; ?> >7O1</option>
				<option <?php if($Format2 == "7E1") echo "selected"; ?> >7E1</option>
				<option <?php if($Format2 == "7N2") echo "selected"; ?> >7N2</option>
				<option <?php if($Format2 == "7O2") echo "selected"; ?> >7O2</option>
				<option <?php if($Format2 == "7E2") echo "selected"; ?> >7E2</option>
				</select>
				(Data bit, Parity, Stop bit)
			</td>
		</tr>


		<tr title="The firmware will run immediately after you press 'Modify' button">
			<td bgcolor="#ccffff">Enable Funcion</td>
			<td ><input size="20" name="enable" type="checkbox" value="enable"<?php if($enable=="enable") echo "checked";?> >Enable <br>
			</td>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Alive</td>
			<?php
				if($vxsc_alive == "true")
				{
					echo '<td bgcolor="#33ff33">True</td>'."\n";
				}else
				{
					echo '<td bgcolor="#cccccc">False</td>'."\n";
				}
			?>
		</tr>

		<tr>
			<td bgcolor="#ccffff">Firmware Version</td>
			<td ><?php echo $vxsc_version;?></td>
		</tr>


		<tr align="center">
			<td colspan="2"><input name="submit" value="Modify" type="submit"><br>
			</td>
		</tr>

		<tr>
			<td colspan="2">
			(1)Heartbeat Time: if this value is small, it is sensitive to detect network disconnected<br>
			(2)Virtual IP: please set it different from other virtual COM device<br>
			</td>
		</tr>

		</tbody>
		</table>

		<br>
		<br>
	</form>
	<br>
	<br>
</body>
</html>

